package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ServiceProfileId,
  ServiceProfileName,
  ServiceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetServiceProfileResponse(
    arn: Optional[ServiceProfileArn] = Optional.Absent,
    name: Optional[ServiceProfileName] = Optional.Absent,
    id: Optional[ServiceProfileId] = Optional.Absent,
    loRaWAN: Optional[zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse = {
    import GetServiceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ServiceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => ServiceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly =
    zio.aws.iotwireless.model.GetServiceProfileResponse.wrap(buildAwsValue())
}
object GetServiceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetServiceProfileResponse =
      zio.aws.iotwireless.model.GetServiceProfileResponse(
        arn.map(value => value),
        name.map(value => value),
        id.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def arn: Optional[ServiceProfileArn]
    def name: Optional[ServiceProfileName]
    def id: Optional[ServiceProfileId]
    def loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly
    ]
    def getArn: ZIO[Any, AwsError, ServiceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ServiceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("id", id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse
  ) extends zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly {
    override val arn: Optional[ServiceProfileArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileArn(value)
      )
    override val name: Optional[ServiceProfileName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileName(value)
      )
    override val id: Optional[ServiceProfileId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
      )
    override val loRaWAN: Optional[
      zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANGetServiceProfileInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceProfileResponse
  ): zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
