package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ServiceProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetServiceProfileRequest(id: ServiceProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest = {
    import GetServiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest
      .builder()
      .id(ServiceProfileId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetServiceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.GetServiceProfileRequest.wrap(buildAwsValue())
}
object GetServiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetServiceProfileRequest =
      zio.aws.iotwireless.model.GetServiceProfileRequest(id)
    def id: ServiceProfileId
    def getId: ZIO[Any, Nothing, ServiceProfileId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest
  ) extends zio.aws.iotwireless.model.GetServiceProfileRequest.ReadOnly {
    override val id: ServiceProfileId =
      zio.aws.iotwireless.model.primitives.ServiceProfileId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetServiceProfileRequest
  ): zio.aws.iotwireless.model.GetServiceProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
