package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResourceEventConfigurationResponse(
    deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
    ] = Optional.Absent,
    proximity: Optional[zio.aws.iotwireless.model.ProximityEventConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse = {
    import GetResourceEventConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
      .builder()
      .optionallyWith(
        deviceRegistrationState.map(value => value.buildAwsValue())
      )(_.deviceRegistrationState)
      .optionallyWith(proximity.map(value => value.buildAwsValue()))(
        _.proximity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly =
    zio.aws.iotwireless.model.GetResourceEventConfigurationResponse
      .wrap(buildAwsValue())
}
object GetResourceEventConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetResourceEventConfigurationResponse =
      zio.aws.iotwireless.model.GetResourceEventConfigurationResponse(
        deviceRegistrationState.map(value => value.asEditable),
        proximity.map(value => value.asEditable)
      )
    def deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ]
    def proximity: Optional[
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ]
    def getDeviceRegistrationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceRegistrationState",
      deviceRegistrationState
    )
    def getProximity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("proximity", proximity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ) extends zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly {
    override val deviceRegistrationState: Optional[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceRegistrationState())
      .map(value =>
        zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
          .wrap(value)
      )
    override val proximity: Optional[
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proximity())
      .map(value =>
        zio.aws.iotwireless.model.ProximityEventConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetResourceEventConfigurationResponse
  ): zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
