package zio.aws.iotwireless.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.iotwireless.model.primitives.FPort
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FPorts(
    fuota: Optional[FPort] = Optional.Absent,
    multicast: Optional[FPort] = Optional.Absent,
    clockSync: Optional[FPort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.FPorts = {
    import FPorts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.FPorts
      .builder()
      .optionallyWith(fuota.map(value => FPort.unwrap(value): Integer))(_.fuota)
      .optionallyWith(multicast.map(value => FPort.unwrap(value): Integer))(
        _.multicast
      )
      .optionallyWith(clockSync.map(value => FPort.unwrap(value): Integer))(
        _.clockSync
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.FPorts.ReadOnly =
    zio.aws.iotwireless.model.FPorts.wrap(buildAwsValue())
}
object FPorts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.FPorts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.FPorts =
      zio.aws.iotwireless.model.FPorts(
        fuota.map(value => value),
        multicast.map(value => value),
        clockSync.map(value => value)
      )
    def fuota: Optional[FPort]
    def multicast: Optional[FPort]
    def clockSync: Optional[FPort]
    def getFuota: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fuota", fuota)
    def getMulticast: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("multicast", multicast)
    def getClockSync: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("clockSync", clockSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.FPorts
  ) extends zio.aws.iotwireless.model.FPorts.ReadOnly {
    override val fuota: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.fuota())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val multicast: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.multicast())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val clockSync: Optional[FPort] = zio.aws.core.internal
      .optionalFromNullable(impl.clockSync())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.FPorts
  ): zio.aws.iotwireless.model.FPorts.ReadOnly = new Wrapper(impl)
}
