package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeviceRegistrationStateEventConfiguration(
    sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration = {
    import DeviceRegistrationStateEventConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly =
    zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
      .wrap(buildAwsValue())
}
object DeviceRegistrationStateEventConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration =
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration(
        sidewalk.map(value => value.asEditable)
      )
    def sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
  ) extends zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly {
    override val sidewalk: Optional[
      zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkEventNotificationConfigurations
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceRegistrationStateEventConfiguration
  ): zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly =
    new Wrapper(impl)
}
