package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DeviceProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDeviceProfileRequest(id: DeviceProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest = {
    import DeleteDeviceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest
      .builder()
      .id(DeviceProfileId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteDeviceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteDeviceProfileRequest.wrap(buildAwsValue())
}
object DeleteDeviceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteDeviceProfileRequest =
      zio.aws.iotwireless.model.DeleteDeviceProfileRequest(id)
    def id: DeviceProfileId
    def getId: ZIO[Any, Nothing, DeviceProfileId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest
  ) extends zio.aws.iotwireless.model.DeleteDeviceProfileRequest.ReadOnly {
    override val id: DeviceProfileId =
      zio.aws.iotwireless.model.primitives.DeviceProfileId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteDeviceProfileRequest
  ): zio.aws.iotwireless.model.DeleteDeviceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
