package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateWirelessGatewayTaskResponse(
    wirelessGatewayTaskDefinitionId: Optional[WirelessGatewayTaskDefinitionId] =
      Optional.Absent,
    status: Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse = {
    import CreateWirelessGatewayTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse
      .builder()
      .optionallyWith(
        wirelessGatewayTaskDefinitionId.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.wirelessGatewayTaskDefinitionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse
      .wrap(buildAwsValue())
}
object CreateWirelessGatewayTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse =
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse(
        wirelessGatewayTaskDefinitionId.map(value => value),
        status.map(value => value)
      )
    def wirelessGatewayTaskDefinitionId
        : Optional[WirelessGatewayTaskDefinitionId]
    def status: Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus]
    def getWirelessGatewayTaskDefinitionId
        : ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField(
        "wirelessGatewayTaskDefinitionId",
        wirelessGatewayTaskDefinitionId
      )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayTaskStatus
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse
  ) extends zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly {
    override val wirelessGatewayTaskDefinitionId
        : Optional[WirelessGatewayTaskDefinitionId] = zio.aws.core.internal
      .optionalFromNullable(impl.wirelessGatewayTaskDefinitionId())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionId(value)
      )
    override val status
        : Optional[zio.aws.iotwireless.model.WirelessGatewayTaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotwireless.model.WirelessGatewayTaskStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateWirelessGatewayTaskResponse
  ): zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly =
    new Wrapper(impl)
}
