package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  IotCertificateId,
  WirelessGatewayId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateWirelessGatewayWithCertificateRequest(
    id: WirelessGatewayId,
    iotCertificateId: IotCertificateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest = {
    import AssociateWirelessGatewayWithCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
      .builder()
      .id(WirelessGatewayId.unwrap(id): java.lang.String)
      .iotCertificateId(
        IotCertificateId.unwrap(iotCertificateId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
      .wrap(buildAwsValue())
}
object AssociateWirelessGatewayWithCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest =
      zio.aws.iotwireless.model
        .AssociateWirelessGatewayWithCertificateRequest(id, iotCertificateId)
    def id: WirelessGatewayId
    def iotCertificateId: IotCertificateId
    def getId: ZIO[Any, Nothing, WirelessGatewayId] = ZIO.succeed(id)
    def getIotCertificateId: ZIO[Any, Nothing, IotCertificateId] =
      ZIO.succeed(iotCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
  ) extends zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest.ReadOnly {
    override val id: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives.WirelessGatewayId(impl.id())
    override val iotCertificateId: IotCertificateId =
      zio.aws.iotwireless.model.primitives
        .IotCertificateId(impl.iotCertificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
  ): zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
