package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DevAddr
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AbpV1_1(
    devAddr: Optional[DevAddr] = Optional.Absent,
    sessionKeys: Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AbpV1_1 = {
    import AbpV1_1.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AbpV1_1
      .builder()
      .optionallyWith(
        devAddr.map(value => DevAddr.unwrap(value): java.lang.String)
      )(_.devAddr)
      .optionallyWith(sessionKeys.map(value => value.buildAwsValue()))(
        _.sessionKeys
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.AbpV1_1.ReadOnly =
    zio.aws.iotwireless.model.AbpV1_1.wrap(buildAwsValue())
}
object AbpV1_1 {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.AbpV1_1 =
      zio.aws.iotwireless.model.AbpV1_1(
        devAddr.map(value => value),
        sessionKeys.map(value => value.asEditable)
      )
    def devAddr: Optional[DevAddr]
    def sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly]
    def getDevAddr: ZIO[Any, AwsError, DevAddr] =
      AwsError.unwrapOptionField("devAddr", devAddr)
    def getSessionKeys: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly
    ] = AwsError.unwrapOptionField("sessionKeys", sessionKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ) extends zio.aws.iotwireless.model.AbpV1_1.ReadOnly {
    override val devAddr: Optional[DevAddr] = zio.aws.core.internal
      .optionalFromNullable(impl.devAddr())
      .map(value => zio.aws.iotwireless.model.primitives.DevAddr(value))
    override val sessionKeys
        : Optional[zio.aws.iotwireless.model.SessionKeysAbpV1_1.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionKeys())
        .map(value => zio.aws.iotwireless.model.SessionKeysAbpV1_1.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_1
  ): zio.aws.iotwireless.model.AbpV1_1.ReadOnly = new Wrapper(impl)
}
