package zio.aws.iotwireless
import zio.aws.iotwireless.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.iotwireless.{
  IotWirelessAsyncClientBuilder,
  IotWirelessAsyncClient
}
import software.amazon.awssdk.services.iotwireless.model.{
  GetDestinationResponse,
  AssociateWirelessGatewayWithCertificateResponse,
  GetWirelessGatewayTaskDefinitionRequest,
  UpdateMulticastGroupRequest,
  SendDataToWirelessDeviceRequest,
  DownlinkQueueMessage,
  TestWirelessDeviceRequest,
  ListMulticastGroupsByFuotaTaskResponse,
  StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse,
  DisassociateWirelessGatewayFromCertificateResponse,
  DisassociateWirelessDeviceFromFuotaTaskResponse,
  DeleteFuotaTaskRequest,
  GetDeviceProfileResponse,
  UpdateNetworkAnalyzerConfigurationRequest,
  ResetAllResourceLogLevelsResponse,
  DeleteWirelessGatewayTaskDefinitionRequest,
  DeleteDestinationResponse,
  StartMulticastGroupSessionResponse,
  CreateWirelessDeviceRequest,
  GetDeviceProfileRequest,
  CreateFuotaTaskRequest,
  CancelMulticastGroupSessionRequest,
  DisassociateWirelessGatewayFromThingRequest,
  GetNetworkAnalyzerConfigurationResponse,
  DisassociateWirelessDeviceFromFuotaTaskRequest,
  GetWirelessDeviceResponse,
  GetMulticastGroupResponse,
  DisassociateWirelessDeviceFromThingRequest,
  GetNetworkAnalyzerConfigurationRequest,
  ListWirelessGatewayTaskDefinitionsRequest,
  SidewalkAccountInfoWithFingerprint,
  UpdateDestinationRequest,
  UpdateResourceEventConfigurationRequest,
  CreateServiceProfileResponse,
  GetPartnerAccountRequest,
  UpdatePartnerAccountRequest,
  CreateWirelessGatewayTaskDefinitionResponse,
  GetFuotaTaskResponse,
  ListFuotaTasksResponse,
  MulticastGroup,
  StartBulkAssociateWirelessDeviceWithMulticastGroupRequest,
  GetMulticastGroupSessionResponse,
  UpdateWirelessGatewayTaskEntry,
  GetFuotaTaskRequest,
  GetWirelessGatewayTaskDefinitionResponse,
  AssociateMulticastGroupWithFuotaTaskResponse,
  DeleteWirelessGatewayTaskDefinitionResponse,
  DeleteServiceProfileResponse,
  DeleteMulticastGroupResponse,
  SendDataToMulticastGroupResponse,
  DeleteDeviceProfileResponse,
  CreateDestinationResponse,
  UpdatePartnerAccountResponse,
  AssociateAwsAccountWithPartnerAccountRequest,
  CancelMulticastGroupSessionResponse,
  UpdateDestinationResponse,
  GetLogLevelsByResourceTypesRequest,
  DisassociateAwsAccountFromPartnerAccountResponse,
  DisassociateWirelessDeviceFromMulticastGroupRequest,
  CreateDestinationRequest,
  GetWirelessGatewayFirmwareInformationResponse,
  AssociateWirelessDeviceWithMulticastGroupRequest,
  AssociateWirelessDeviceWithThingRequest,
  GetPartnerAccountResponse,
  GetMulticastGroupSessionRequest,
  DeviceProfile,
  ListDeviceProfilesResponse,
  UpdateWirelessDeviceRequest,
  ListMulticastGroupsRequest,
  DeleteQueuedMessagesRequest,
  UpdateNetworkAnalyzerConfigurationResponse,
  GetWirelessGatewayResponse,
  UpdateFuotaTaskRequest,
  ListTagsForResourceRequest,
  CreateWirelessGatewayTaskDefinitionRequest,
  DeleteWirelessGatewayTaskRequest,
  ListQueuedMessagesRequest,
  ListFuotaTasksRequest,
  AssociateWirelessDeviceWithFuotaTaskResponse,
  GetWirelessGatewayCertificateResponse,
  StartFuotaTaskRequest,
  GetWirelessGatewayCertificateRequest,
  DeleteFuotaTaskResponse,
  GetLogLevelsByResourceTypesResponse,
  DeleteDeviceProfileRequest,
  GetResourceEventConfigurationRequest,
  DeleteWirelessGatewayTaskResponse,
  CreateDeviceProfileRequest,
  ListTagsForResourceResponse,
  AssociateWirelessDeviceWithThingResponse,
  UntagResourceResponse,
  AssociateAwsAccountWithPartnerAccountResponse,
  CreateWirelessDeviceResponse,
  CreateWirelessGatewayRequest,
  ListQueuedMessagesResponse,
  DeleteDestinationRequest,
  ListDestinationsRequest,
  DeleteWirelessGatewayRequest,
  SendDataToWirelessDeviceResponse,
  AssociateMulticastGroupWithFuotaTaskRequest,
  DisassociateMulticastGroupFromFuotaTaskRequest,
  CreateWirelessGatewayTaskResponse,
  ListPartnerAccountsRequest,
  CreateDeviceProfileResponse,
  CreateServiceProfileRequest,
  GetWirelessGatewayTaskRequest,
  DeleteWirelessGatewayResponse,
  StartFuotaTaskResponse,
  UpdateMulticastGroupResponse,
  SendDataToMulticastGroupRequest,
  GetResourceLogLevelRequest,
  GetServiceProfileResponse,
  DeleteMulticastGroupRequest,
  DeleteQueuedMessagesResponse,
  GetDestinationRequest,
  ListDeviceProfilesRequest,
  CreateMulticastGroupRequest,
  GetServiceProfileRequest,
  ListWirelessDevicesRequest,
  GetWirelessGatewayTaskResponse,
  UpdateLogLevelsByResourceTypesResponse,
  ListServiceProfilesRequest,
  ListWirelessGatewayTaskDefinitionsResponse,
  StartBulkAssociateWirelessDeviceWithMulticastGroupResponse,
  CreateWirelessGatewayResponse,
  UpdateWirelessDeviceResponse,
  UpdateWirelessGatewayResponse,
  PutResourceLogLevelRequest,
  ListMulticastGroupsByFuotaTaskRequest,
  Destinations,
  DisassociateMulticastGroupFromFuotaTaskResponse,
  DisassociateWirelessGatewayFromThingResponse,
  UpdateLogLevelsByResourceTypesRequest,
  GetWirelessGatewayStatisticsRequest,
  DisassociateWirelessDeviceFromMulticastGroupResponse,
  UpdateWirelessGatewayRequest,
  UpdateResourceEventConfigurationResponse,
  UntagResourceRequest,
  DeleteWirelessDeviceRequest,
  CreateMulticastGroupResponse,
  GetWirelessDeviceStatisticsRequest,
  DeleteServiceProfileRequest,
  GetWirelessGatewayRequest,
  ResetAllResourceLogLevelsRequest,
  AssociateWirelessGatewayWithCertificateRequest,
  ListMulticastGroupsResponse,
  ResetResourceLogLevelResponse,
  GetResourceLogLevelResponse,
  CreateWirelessGatewayTaskRequest,
  UpdateFuotaTaskResponse,
  FuotaTask,
  MulticastGroupByFuotaTask,
  GetServiceEndpointResponse,
  ResetResourceLogLevelRequest,
  TestWirelessDeviceResponse,
  GetWirelessDeviceStatisticsResponse,
  AssociateWirelessGatewayWithThingRequest,
  ListWirelessGatewaysResponse,
  ServiceProfile,
  DeleteWirelessDeviceResponse,
  AssociateWirelessDeviceWithMulticastGroupResponse,
  WirelessGatewayStatistics,
  PutResourceLogLevelResponse,
  DisassociateWirelessDeviceFromThingResponse,
  ListServiceProfilesResponse,
  ListWirelessDevicesResponse,
  GetServiceEndpointRequest,
  TagResourceResponse,
  GetResourceEventConfigurationResponse,
  CreateFuotaTaskResponse,
  StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest,
  WirelessDeviceStatistics,
  GetWirelessGatewayFirmwareInformationRequest,
  DisassociateWirelessGatewayFromCertificateRequest,
  GetWirelessGatewayStatisticsResponse,
  AssociateWirelessDeviceWithFuotaTaskRequest,
  TagResourceRequest,
  ListDestinationsResponse,
  ListWirelessGatewaysRequest,
  StartMulticastGroupSessionRequest,
  AssociateWirelessGatewayWithThingResponse,
  GetMulticastGroupRequest,
  ListPartnerAccountsResponse,
  DisassociateAwsAccountFromPartnerAccountRequest,
  GetWirelessDeviceRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait IotWireless extends AspectSupport[IotWireless] {
  val api: IotWirelessAsyncClient
  def cancelMulticastGroupSession(
      request: zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.ReadOnly
  ]
  def getWirelessGatewayStatistics(
      request: zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly
  ]
  def createWirelessGateway(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly
  ]
  def listWirelessGatewayTaskDefinitions(
      request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
  ]
  def listWirelessGatewayTaskDefinitionsPaginated(
      request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly
  ]
  def associateWirelessGatewayWithCertificate(
      request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly
  ]
  def listServiceProfiles(
      request: zio.aws.iotwireless.model.ListServiceProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.iotwireless.model.ServiceProfile.ReadOnly]
  def listServiceProfilesPaginated(
      request: zio.aws.iotwireless.model.ListServiceProfilesRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly
  ]
  def testWirelessDevice(
      request: zio.aws.iotwireless.model.TestWirelessDeviceRequest
  ): IO[AwsError, zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly]
  def deleteDeviceProfile(
      request: zio.aws.iotwireless.model.DeleteDeviceProfileRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteDeviceProfileResponse.ReadOnly
  ]
  def deleteServiceProfile(
      request: zio.aws.iotwireless.model.DeleteServiceProfileRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteServiceProfileResponse.ReadOnly
  ]
  def getMulticastGroupSession(
      request: zio.aws.iotwireless.model.GetMulticastGroupSessionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.ReadOnly
  ]
  def updateFuotaTask(
      request: zio.aws.iotwireless.model.UpdateFuotaTaskRequest
  ): IO[AwsError, zio.aws.iotwireless.model.UpdateFuotaTaskResponse.ReadOnly]
  def getLogLevelsByResourceTypes(
      request: zio.aws.iotwireless.model.GetLogLevelsByResourceTypesRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly
  ]
  def getResourceEventConfiguration(
      request: zio.aws.iotwireless.model.GetResourceEventConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly
  ]
  def listFuotaTasks(
      request: zio.aws.iotwireless.model.ListFuotaTasksRequest
  ): ZStream[Any, AwsError, zio.aws.iotwireless.model.FuotaTask.ReadOnly]
  def listFuotaTasksPaginated(
      request: zio.aws.iotwireless.model.ListFuotaTasksRequest
  ): IO[AwsError, zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly]
  def createDestination(
      request: zio.aws.iotwireless.model.CreateDestinationRequest
  ): IO[AwsError, zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly]
  def resetAllResourceLogLevels(
      request: zio.aws.iotwireless.model.ResetAllResourceLogLevelsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.ReadOnly
  ]
  def listDestinations(
      request: zio.aws.iotwireless.model.ListDestinationsRequest
  ): ZStream[Any, AwsError, zio.aws.iotwireless.model.Destinations.ReadOnly]
  def listDestinationsPaginated(
      request: zio.aws.iotwireless.model.ListDestinationsRequest
  ): IO[AwsError, zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly]
  def updateResourceEventConfiguration(
      request: zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.ReadOnly
  ]
  def createServiceProfile(
      request: zio.aws.iotwireless.model.CreateServiceProfileRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly
  ]
  def getServiceProfile(
      request: zio.aws.iotwireless.model.GetServiceProfileRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly]
  def putResourceLogLevel(
      request: zio.aws.iotwireless.model.PutResourceLogLevelRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.PutResourceLogLevelResponse.ReadOnly
  ]
  def startBulkDisassociateWirelessDeviceFromMulticastGroup(
      request: zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
  ]
  def disassociateWirelessDeviceFromMulticastGroup(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
  ]
  def disassociateWirelessDeviceFromFuotaTask(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.ReadOnly
  ]
  def getWirelessDevice(
      request: zio.aws.iotwireless.model.GetWirelessDeviceRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly]
  def getResourceLogLevel(
      request: zio.aws.iotwireless.model.GetResourceLogLevelRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly
  ]
  def disassociateAwsAccountFromPartnerAccount(
      request: zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.ReadOnly
  ]
  def disassociateWirelessDeviceFromThing(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.ReadOnly
  ]
  def deleteWirelessDevice(
      request: zio.aws.iotwireless.model.DeleteWirelessDeviceRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.ReadOnly
  ]
  def createWirelessDevice(
      request: zio.aws.iotwireless.model.CreateWirelessDeviceRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly
  ]
  def startFuotaTask(
      request: zio.aws.iotwireless.model.StartFuotaTaskRequest
  ): IO[AwsError, zio.aws.iotwireless.model.StartFuotaTaskResponse.ReadOnly]
  def deleteWirelessGatewayTask(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.ReadOnly
  ]
  def associateWirelessDeviceWithFuotaTask(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.ReadOnly
  ]
  def updatePartnerAccount(
      request: zio.aws.iotwireless.model.UpdatePartnerAccountRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdatePartnerAccountResponse.ReadOnly
  ]
  def deleteWirelessGateway(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.ReadOnly
  ]
  def sendDataToMulticastGroup(
      request: zio.aws.iotwireless.model.SendDataToMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly
  ]
  def getFuotaTask(
      request: zio.aws.iotwireless.model.GetFuotaTaskRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly]
  def deleteMulticastGroup(
      request: zio.aws.iotwireless.model.DeleteMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteMulticastGroupResponse.ReadOnly
  ]
  def updateDestination(
      request: zio.aws.iotwireless.model.UpdateDestinationRequest
  ): IO[AwsError, zio.aws.iotwireless.model.UpdateDestinationResponse.ReadOnly]
  def startMulticastGroupSession(
      request: zio.aws.iotwireless.model.StartMulticastGroupSessionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.iotwireless.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.iotwireless.model.UntagResourceResponse.ReadOnly]
  def createFuotaTask(
      request: zio.aws.iotwireless.model.CreateFuotaTaskRequest
  ): IO[AwsError, zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly]
  def associateWirelessDeviceWithMulticastGroup(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
  ]
  def getWirelessGatewayCertificate(
      request: zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly
  ]
  def associateWirelessGatewayWithThing(
      request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.ReadOnly
  ]
  def listWirelessGateways(
      request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
  ]
  def listWirelessGatewaysPaginated(
      request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly
  ]
  def updateWirelessDevice(
      request: zio.aws.iotwireless.model.UpdateWirelessDeviceRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.ReadOnly
  ]
  def sendDataToWirelessDevice(
      request: zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly
  ]
  def createWirelessGatewayTask(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly
  ]
  def updateLogLevelsByResourceTypes(
      request: zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.ReadOnly
  ]
  def updateNetworkAnalyzerConfiguration(
      request: zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.ReadOnly
  ]
  def disassociateMulticastGroupFromFuotaTask(
      request: zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.ReadOnly
  ]
  def associateAwsAccountWithPartnerAccount(
      request: zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.iotwireless.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListTagsForResourceResponse.ReadOnly
  ]
  def deleteQueuedMessages(
      request: zio.aws.iotwireless.model.DeleteQueuedMessagesRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.ReadOnly
  ]
  def getPartnerAccount(
      request: zio.aws.iotwireless.model.GetPartnerAccountRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly]
  def getDestination(
      request: zio.aws.iotwireless.model.GetDestinationRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly]
  def associateMulticastGroupWithFuotaTask(
      request: zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.iotwireless.model.TagResourceRequest
  ): IO[AwsError, ReadOnly]
  def createDeviceProfile(
      request: zio.aws.iotwireless.model.CreateDeviceProfileRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly
  ]
  def deleteWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.ReadOnly
  ]
  def listPartnerAccounts(
      request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
  ]
  def listPartnerAccountsPaginated(
      request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly
  ]
  def listMulticastGroups(
      request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.iotwireless.model.MulticastGroup.ReadOnly]
  def listMulticastGroupsPaginated(
      request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly
  ]
  def disassociateWirelessGatewayFromCertificate(
      request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.ReadOnly
  ]
  def deleteDestination(
      request: zio.aws.iotwireless.model.DeleteDestinationRequest
  ): IO[AwsError, zio.aws.iotwireless.model.DeleteDestinationResponse.ReadOnly]
  def updateMulticastGroup(
      request: zio.aws.iotwireless.model.UpdateMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateMulticastGroupResponse.ReadOnly
  ]
  def getMulticastGroup(
      request: zio.aws.iotwireless.model.GetMulticastGroupRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly]
  def updateWirelessGateway(
      request: zio.aws.iotwireless.model.UpdateWirelessGatewayRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.ReadOnly
  ]
  def getWirelessGatewayTask(
      request: zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly
  ]
  def startBulkAssociateWirelessDeviceWithMulticastGroup(
      request: zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
  ]
  def getWirelessGatewayFirmwareInformation(
      request: zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly
  ]
  def getNetworkAnalyzerConfiguration(
      request: zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly
  ]
  def listMulticastGroupsByFuotaTask(
      request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
  ]
  def listMulticastGroupsByFuotaTaskPaginated(
      request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly
  ]
  def createMulticastGroup(
      request: zio.aws.iotwireless.model.CreateMulticastGroupRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly
  ]
  def createWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly
  ]
  def listWirelessDevices(
      request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
  ]
  def listWirelessDevicesPaginated(
      request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly
  ]
  def getServiceEndpoint(
      request: zio.aws.iotwireless.model.GetServiceEndpointRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly]
  def getWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly
  ]
  def associateWirelessDeviceWithThing(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.ReadOnly
  ]
  def getWirelessDeviceStatistics(
      request: zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly
  ]
  def getDeviceProfile(
      request: zio.aws.iotwireless.model.GetDeviceProfileRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly]
  def getWirelessGateway(
      request: zio.aws.iotwireless.model.GetWirelessGatewayRequest
  ): IO[AwsError, zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly]
  def disassociateWirelessGatewayFromThing(
      request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.ReadOnly
  ]
  def resetResourceLogLevel(
      request: zio.aws.iotwireless.model.ResetResourceLogLevelRequest
  ): IO[
    AwsError,
    zio.aws.iotwireless.model.ResetResourceLogLevelResponse.ReadOnly
  ]
  def listQueuedMessages(
      request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
  ]
  def listQueuedMessagesPaginated(
      request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
  ): IO[AwsError, zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly]
  def listDeviceProfiles(
      request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
  ): ZStream[Any, AwsError, zio.aws.iotwireless.model.DeviceProfile.ReadOnly]
  def listDeviceProfilesPaginated(
      request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
  ): IO[AwsError, zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly]
  def deleteFuotaTask(
      request: zio.aws.iotwireless.model.DeleteFuotaTaskRequest
  ): IO[AwsError, zio.aws.iotwireless.model.DeleteFuotaTaskResponse.ReadOnly]
}
object IotWireless {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IotWireless] = customized(
    identity
  )
  def customized(
      customization: IotWirelessAsyncClientBuilder => IotWirelessAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IotWireless] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IotWirelessAsyncClientBuilder => IotWirelessAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IotWireless] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IotWirelessAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IotWirelessAsyncClient, IotWirelessAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IotWirelessAsyncClient,
      IotWirelessAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IotWirelessImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IotWirelessImpl[R](
      override val api: IotWirelessAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IotWireless
      with AwsServiceBase[R] {
    override val serviceName: String = "IotWireless"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IotWirelessImpl[R1] = new IotWirelessImpl(api, newAspect, r)
    def cancelMulticastGroupSession(
        request: zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelMulticastGroupSessionRequest,
      CancelMulticastGroupSessionResponse
    ]("cancelMulticastGroupSession", api.cancelMulticastGroupSession)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.wrap)
      .provideEnvironment(r)
    def getWirelessGatewayStatistics(
        request: zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayStatisticsRequest,
      GetWirelessGatewayStatisticsResponse
    ]("getWirelessGatewayStatistics", api.getWirelessGatewayStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.wrap)
      .provideEnvironment(r)
    def createWirelessGateway(
        request: zio.aws.iotwireless.model.CreateWirelessGatewayRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWirelessGatewayRequest,
      CreateWirelessGatewayResponse
    ]("createWirelessGateway", api.createWirelessGateway)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.CreateWirelessGatewayResponse.wrap)
      .provideEnvironment(r)
    def listWirelessGatewayTaskDefinitions(
        request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListWirelessGatewayTaskDefinitionsRequest,
      ListWirelessGatewayTaskDefinitionsResponse,
      UpdateWirelessGatewayTaskEntry
    ](
      "listWirelessGatewayTaskDefinitions",
      api.listWirelessGatewayTaskDefinitions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.taskDefinitions().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.wrap(item)
      )
      .provideEnvironment(r)
    def listWirelessGatewayTaskDefinitionsPaginated(
        request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWirelessGatewayTaskDefinitionsRequest,
      ListWirelessGatewayTaskDefinitionsResponse
    ](
      "listWirelessGatewayTaskDefinitions",
      api.listWirelessGatewayTaskDefinitions
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.wrap
      )
      .provideEnvironment(r)
    def associateWirelessGatewayWithCertificate(
        request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateWirelessGatewayWithCertificateRequest,
      AssociateWirelessGatewayWithCertificateResponse
    ](
      "associateWirelessGatewayWithCertificate",
      api.associateWirelessGatewayWithCertificate
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.wrap
      )
      .provideEnvironment(r)
    def listServiceProfiles(
        request: zio.aws.iotwireless.model.ListServiceProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ServiceProfile.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListServiceProfilesRequest,
      ListServiceProfilesResponse,
      ServiceProfile
    ](
      "listServiceProfiles",
      api.listServiceProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.serviceProfileList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iotwireless.model.ServiceProfile.wrap(item))
      .provideEnvironment(r)
    def listServiceProfilesPaginated(
        request: zio.aws.iotwireless.model.ListServiceProfilesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListServiceProfilesRequest,
      ListServiceProfilesResponse
    ]("listServiceProfiles", api.listServiceProfiles)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListServiceProfilesResponse.wrap)
      .provideEnvironment(r)
    def testWirelessDevice(
        request: zio.aws.iotwireless.model.TestWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      TestWirelessDeviceRequest,
      TestWirelessDeviceResponse
    ]("testWirelessDevice", api.testWirelessDevice)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.TestWirelessDeviceResponse.wrap)
      .provideEnvironment(r)
    def deleteDeviceProfile(
        request: zio.aws.iotwireless.model.DeleteDeviceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteDeviceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDeviceProfileRequest,
      DeleteDeviceProfileResponse
    ]("deleteDeviceProfile", api.deleteDeviceProfile)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteDeviceProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteServiceProfile(
        request: zio.aws.iotwireless.model.DeleteServiceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteServiceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteServiceProfileRequest,
      DeleteServiceProfileResponse
    ]("deleteServiceProfile", api.deleteServiceProfile)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteServiceProfileResponse.wrap)
      .provideEnvironment(r)
    def getMulticastGroupSession(
        request: zio.aws.iotwireless.model.GetMulticastGroupSessionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetMulticastGroupSessionRequest,
      GetMulticastGroupSessionResponse
    ]("getMulticastGroupSession", api.getMulticastGroupSession)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.wrap)
      .provideEnvironment(r)
    def updateFuotaTask(
        request: zio.aws.iotwireless.model.UpdateFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[UpdateFuotaTaskRequest, UpdateFuotaTaskResponse](
      "updateFuotaTask",
      api.updateFuotaTask
    )(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.UpdateFuotaTaskResponse.wrap)
      .provideEnvironment(r)
    def getLogLevelsByResourceTypes(
        request: zio.aws.iotwireless.model.GetLogLevelsByResourceTypesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLogLevelsByResourceTypesRequest,
      GetLogLevelsByResourceTypesResponse
    ]("getLogLevelsByResourceTypes", api.getLogLevelsByResourceTypes)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.wrap)
      .provideEnvironment(r)
    def getResourceEventConfiguration(
        request: zio.aws.iotwireless.model.GetResourceEventConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourceEventConfigurationRequest,
      GetResourceEventConfigurationResponse
    ]("getResourceEventConfiguration", api.getResourceEventConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listFuotaTasks(
        request: zio.aws.iotwireless.model.ListFuotaTasksRequest
    ): ZStream[Any, AwsError, zio.aws.iotwireless.model.FuotaTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListFuotaTasksRequest,
        ListFuotaTasksResponse,
        FuotaTask
      ](
        "listFuotaTasks",
        api.listFuotaTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fuotaTaskList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.iotwireless.model.FuotaTask.wrap(item))
        .provideEnvironment(r)
    def listFuotaTasksPaginated(
        request: zio.aws.iotwireless.model.ListFuotaTasksRequest
    ): IO[AwsError, zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly] =
      asyncRequestResponse[ListFuotaTasksRequest, ListFuotaTasksResponse](
        "listFuotaTasks",
        api.listFuotaTasks
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.ListFuotaTasksResponse.wrap)
        .provideEnvironment(r)
    def createDestination(
        request: zio.aws.iotwireless.model.CreateDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[CreateDestinationRequest, CreateDestinationResponse](
        "createDestination",
        api.createDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.CreateDestinationResponse.wrap)
        .provideEnvironment(r)
    def resetAllResourceLogLevels(
        request: zio.aws.iotwireless.model.ResetAllResourceLogLevelsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetAllResourceLogLevelsRequest,
      ResetAllResourceLogLevelsResponse
    ]("resetAllResourceLogLevels", api.resetAllResourceLogLevels)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.wrap)
      .provideEnvironment(r)
    def listDestinations(
        request: zio.aws.iotwireless.model.ListDestinationsRequest
    ): ZStream[Any, AwsError, zio.aws.iotwireless.model.Destinations.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListDestinationsRequest,
        ListDestinationsResponse,
        Destinations
      ](
        "listDestinations",
        api.listDestinations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.destinationList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.iotwireless.model.Destinations.wrap(item))
        .provideEnvironment(r)
    def listDestinationsPaginated(
        request: zio.aws.iotwireless.model.ListDestinationsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly
    ] = asyncRequestResponse[ListDestinationsRequest, ListDestinationsResponse](
      "listDestinations",
      api.listDestinations
    )(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListDestinationsResponse.wrap)
      .provideEnvironment(r)
    def updateResourceEventConfiguration(
        request: zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateResourceEventConfigurationRequest,
      UpdateResourceEventConfigurationResponse
    ]("updateResourceEventConfiguration", api.updateResourceEventConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.wrap
    ).provideEnvironment(r)
    def createServiceProfile(
        request: zio.aws.iotwireless.model.CreateServiceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateServiceProfileRequest,
      CreateServiceProfileResponse
    ]("createServiceProfile", api.createServiceProfile)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.CreateServiceProfileResponse.wrap)
      .provideEnvironment(r)
    def getServiceProfile(
        request: zio.aws.iotwireless.model.GetServiceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly
    ] =
      asyncRequestResponse[GetServiceProfileRequest, GetServiceProfileResponse](
        "getServiceProfile",
        api.getServiceProfile
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetServiceProfileResponse.wrap)
        .provideEnvironment(r)
    def putResourceLogLevel(
        request: zio.aws.iotwireless.model.PutResourceLogLevelRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.PutResourceLogLevelResponse.ReadOnly
    ] = asyncRequestResponse[
      PutResourceLogLevelRequest,
      PutResourceLogLevelResponse
    ]("putResourceLogLevel", api.putResourceLogLevel)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.PutResourceLogLevelResponse.wrap)
      .provideEnvironment(r)
    def startBulkDisassociateWirelessDeviceFromMulticastGroup(
        request: zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest,
      StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse
    ](
      "startBulkDisassociateWirelessDeviceFromMulticastGroup",
      api.startBulkDisassociateWirelessDeviceFromMulticastGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateWirelessDeviceFromMulticastGroup(
        request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateWirelessDeviceFromMulticastGroupRequest,
      DisassociateWirelessDeviceFromMulticastGroupResponse
    ](
      "disassociateWirelessDeviceFromMulticastGroup",
      api.disassociateWirelessDeviceFromMulticastGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateWirelessDeviceFromFuotaTask(
        request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateWirelessDeviceFromFuotaTaskRequest,
      DisassociateWirelessDeviceFromFuotaTaskResponse
    ](
      "disassociateWirelessDeviceFromFuotaTask",
      api.disassociateWirelessDeviceFromFuotaTask
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.wrap
      )
      .provideEnvironment(r)
    def getWirelessDevice(
        request: zio.aws.iotwireless.model.GetWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly
    ] =
      asyncRequestResponse[GetWirelessDeviceRequest, GetWirelessDeviceResponse](
        "getWirelessDevice",
        api.getWirelessDevice
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetWirelessDeviceResponse.wrap)
        .provideEnvironment(r)
    def getResourceLogLevel(
        request: zio.aws.iotwireless.model.GetResourceLogLevelRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly
    ] = asyncRequestResponse[
      GetResourceLogLevelRequest,
      GetResourceLogLevelResponse
    ]("getResourceLogLevel", api.getResourceLogLevel)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.GetResourceLogLevelResponse.wrap)
      .provideEnvironment(r)
    def disassociateAwsAccountFromPartnerAccount(
        request: zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateAwsAccountFromPartnerAccountRequest,
      DisassociateAwsAccountFromPartnerAccountResponse
    ](
      "disassociateAwsAccountFromPartnerAccount",
      api.disassociateAwsAccountFromPartnerAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateWirelessDeviceFromThing(
        request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateWirelessDeviceFromThingRequest,
      DisassociateWirelessDeviceFromThingResponse
    ](
      "disassociateWirelessDeviceFromThing",
      api.disassociateWirelessDeviceFromThing
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.wrap
      )
      .provideEnvironment(r)
    def deleteWirelessDevice(
        request: zio.aws.iotwireless.model.DeleteWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteWirelessDeviceRequest,
      DeleteWirelessDeviceResponse
    ]("deleteWirelessDevice", api.deleteWirelessDevice)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.wrap)
      .provideEnvironment(r)
    def createWirelessDevice(
        request: zio.aws.iotwireless.model.CreateWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWirelessDeviceRequest,
      CreateWirelessDeviceResponse
    ]("createWirelessDevice", api.createWirelessDevice)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.CreateWirelessDeviceResponse.wrap)
      .provideEnvironment(r)
    def startFuotaTask(
        request: zio.aws.iotwireless.model.StartFuotaTaskRequest
    ): IO[AwsError, zio.aws.iotwireless.model.StartFuotaTaskResponse.ReadOnly] =
      asyncRequestResponse[StartFuotaTaskRequest, StartFuotaTaskResponse](
        "startFuotaTask",
        api.startFuotaTask
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.StartFuotaTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteWirelessGatewayTask(
        request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteWirelessGatewayTaskRequest,
      DeleteWirelessGatewayTaskResponse
    ]("deleteWirelessGatewayTask", api.deleteWirelessGatewayTask)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.wrap)
      .provideEnvironment(r)
    def associateWirelessDeviceWithFuotaTask(
        request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateWirelessDeviceWithFuotaTaskRequest,
      AssociateWirelessDeviceWithFuotaTaskResponse
    ](
      "associateWirelessDeviceWithFuotaTask",
      api.associateWirelessDeviceWithFuotaTask
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.wrap
      )
      .provideEnvironment(r)
    def updatePartnerAccount(
        request: zio.aws.iotwireless.model.UpdatePartnerAccountRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdatePartnerAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdatePartnerAccountRequest,
      UpdatePartnerAccountResponse
    ]("updatePartnerAccount", api.updatePartnerAccount)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.UpdatePartnerAccountResponse.wrap)
      .provideEnvironment(r)
    def deleteWirelessGateway(
        request: zio.aws.iotwireless.model.DeleteWirelessGatewayRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteWirelessGatewayRequest,
      DeleteWirelessGatewayResponse
    ]("deleteWirelessGateway", api.deleteWirelessGateway)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.wrap)
      .provideEnvironment(r)
    def sendDataToMulticastGroup(
        request: zio.aws.iotwireless.model.SendDataToMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      SendDataToMulticastGroupRequest,
      SendDataToMulticastGroupResponse
    ]("sendDataToMulticastGroup", api.sendDataToMulticastGroup)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.wrap)
      .provideEnvironment(r)
    def getFuotaTask(
        request: zio.aws.iotwireless.model.GetFuotaTaskRequest
    ): IO[AwsError, zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly] =
      asyncRequestResponse[GetFuotaTaskRequest, GetFuotaTaskResponse](
        "getFuotaTask",
        api.getFuotaTask
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetFuotaTaskResponse.wrap)
        .provideEnvironment(r)
    def deleteMulticastGroup(
        request: zio.aws.iotwireless.model.DeleteMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteMulticastGroupRequest,
      DeleteMulticastGroupResponse
    ]("deleteMulticastGroup", api.deleteMulticastGroup)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteMulticastGroupResponse.wrap)
      .provideEnvironment(r)
    def updateDestination(
        request: zio.aws.iotwireless.model.UpdateDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdateDestinationRequest, UpdateDestinationResponse](
        "updateDestination",
        api.updateDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.UpdateDestinationResponse.wrap)
        .provideEnvironment(r)
    def startMulticastGroupSession(
        request: zio.aws.iotwireless.model.StartMulticastGroupSessionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartMulticastGroupSessionRequest,
      StartMulticastGroupSessionResponse
    ]("startMulticastGroupSession", api.startMulticastGroupSession)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.iotwireless.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.iotwireless.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createFuotaTask(
        request: zio.aws.iotwireless.model.CreateFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[CreateFuotaTaskRequest, CreateFuotaTaskResponse](
      "createFuotaTask",
      api.createFuotaTask
    )(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.CreateFuotaTaskResponse.wrap)
      .provideEnvironment(r)
    def associateWirelessDeviceWithMulticastGroup(
        request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateWirelessDeviceWithMulticastGroupRequest,
      AssociateWirelessDeviceWithMulticastGroupResponse
    ](
      "associateWirelessDeviceWithMulticastGroup",
      api.associateWirelessDeviceWithMulticastGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.wrap
      )
      .provideEnvironment(r)
    def getWirelessGatewayCertificate(
        request: zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayCertificateRequest,
      GetWirelessGatewayCertificateResponse
    ]("getWirelessGatewayCertificate", api.getWirelessGatewayCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.wrap)
      .provideEnvironment(r)
    def associateWirelessGatewayWithThing(
        request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateWirelessGatewayWithThingRequest,
      AssociateWirelessGatewayWithThingResponse
    ](
      "associateWirelessGatewayWithThing",
      api.associateWirelessGatewayWithThing
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.wrap
      )
      .provideEnvironment(r)
    def listWirelessGateways(
        request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListWirelessGatewaysRequest,
      ListWirelessGatewaysResponse,
      WirelessGatewayStatistics
    ](
      "listWirelessGateways",
      api.listWirelessGateways,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.wirelessGatewayList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotwireless.model.WirelessGatewayStatistics.wrap(item)
      )
      .provideEnvironment(r)
    def listWirelessGatewaysPaginated(
        request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWirelessGatewaysRequest,
      ListWirelessGatewaysResponse
    ]("listWirelessGateways", api.listWirelessGateways)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListWirelessGatewaysResponse.wrap)
      .provideEnvironment(r)
    def updateWirelessDevice(
        request: zio.aws.iotwireless.model.UpdateWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateWirelessDeviceRequest,
      UpdateWirelessDeviceResponse
    ]("updateWirelessDevice", api.updateWirelessDevice)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.wrap)
      .provideEnvironment(r)
    def sendDataToWirelessDevice(
        request: zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly
    ] = asyncRequestResponse[
      SendDataToWirelessDeviceRequest,
      SendDataToWirelessDeviceResponse
    ]("sendDataToWirelessDevice", api.sendDataToWirelessDevice)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.wrap)
      .provideEnvironment(r)
    def createWirelessGatewayTask(
        request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWirelessGatewayTaskRequest,
      CreateWirelessGatewayTaskResponse
    ]("createWirelessGatewayTask", api.createWirelessGatewayTask)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.wrap)
      .provideEnvironment(r)
    def updateLogLevelsByResourceTypes(
        request: zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLogLevelsByResourceTypesRequest,
      UpdateLogLevelsByResourceTypesResponse
    ]("updateLogLevelsByResourceTypes", api.updateLogLevelsByResourceTypes)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.wrap)
      .provideEnvironment(r)
    def updateNetworkAnalyzerConfiguration(
        request: zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateNetworkAnalyzerConfigurationRequest,
      UpdateNetworkAnalyzerConfigurationResponse
    ](
      "updateNetworkAnalyzerConfiguration",
      api.updateNetworkAnalyzerConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateMulticastGroupFromFuotaTask(
        request: zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateMulticastGroupFromFuotaTaskRequest,
      DisassociateMulticastGroupFromFuotaTaskResponse
    ](
      "disassociateMulticastGroupFromFuotaTask",
      api.disassociateMulticastGroupFromFuotaTask
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.wrap
      )
      .provideEnvironment(r)
    def associateAwsAccountWithPartnerAccount(
        request: zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateAwsAccountWithPartnerAccountRequest,
      AssociateAwsAccountWithPartnerAccountResponse
    ](
      "associateAwsAccountWithPartnerAccount",
      api.associateAwsAccountWithPartnerAccount
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.wrap
      )
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.iotwireless.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteQueuedMessages(
        request: zio.aws.iotwireless.model.DeleteQueuedMessagesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteQueuedMessagesRequest,
      DeleteQueuedMessagesResponse
    ]("deleteQueuedMessages", api.deleteQueuedMessages)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.wrap)
      .provideEnvironment(r)
    def getPartnerAccount(
        request: zio.aws.iotwireless.model.GetPartnerAccountRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly
    ] =
      asyncRequestResponse[GetPartnerAccountRequest, GetPartnerAccountResponse](
        "getPartnerAccount",
        api.getPartnerAccount
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetPartnerAccountResponse.wrap)
        .provideEnvironment(r)
    def getDestination(
        request: zio.aws.iotwireless.model.GetDestinationRequest
    ): IO[AwsError, zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly] =
      asyncRequestResponse[GetDestinationRequest, GetDestinationResponse](
        "getDestination",
        api.getDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetDestinationResponse.wrap)
        .provideEnvironment(r)
    def associateMulticastGroupWithFuotaTask(
        request: zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateMulticastGroupWithFuotaTaskRequest,
      AssociateMulticastGroupWithFuotaTaskResponse
    ](
      "associateMulticastGroupWithFuotaTask",
      api.associateMulticastGroupWithFuotaTask
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.wrap
      )
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.iotwireless.model.TagResourceRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createDeviceProfile(
        request: zio.aws.iotwireless.model.CreateDeviceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateDeviceProfileRequest,
      CreateDeviceProfileResponse
    ]("createDeviceProfile", api.createDeviceProfile)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.CreateDeviceProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteWirelessGatewayTaskDefinition(
        request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteWirelessGatewayTaskDefinitionRequest,
      DeleteWirelessGatewayTaskDefinitionResponse
    ](
      "deleteWirelessGatewayTaskDefinition",
      api.deleteWirelessGatewayTaskDefinition
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def listPartnerAccounts(
        request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListPartnerAccountsRequest,
      ListPartnerAccountsResponse,
      SidewalkAccountInfoWithFingerprint
    ](
      "listPartnerAccounts",
      api.listPartnerAccounts,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.sidewalk().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.wrap(item)
      )
      .provideEnvironment(r)
    def listPartnerAccountsPaginated(
        request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPartnerAccountsRequest,
      ListPartnerAccountsResponse
    ]("listPartnerAccounts", api.listPartnerAccounts)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListPartnerAccountsResponse.wrap)
      .provideEnvironment(r)
    def listMulticastGroups(
        request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.MulticastGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListMulticastGroupsRequest,
      ListMulticastGroupsResponse,
      MulticastGroup
    ](
      "listMulticastGroups",
      api.listMulticastGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multicastGroupList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iotwireless.model.MulticastGroup.wrap(item))
      .provideEnvironment(r)
    def listMulticastGroupsPaginated(
        request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMulticastGroupsRequest,
      ListMulticastGroupsResponse
    ]("listMulticastGroups", api.listMulticastGroups)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListMulticastGroupsResponse.wrap)
      .provideEnvironment(r)
    def disassociateWirelessGatewayFromCertificate(
        request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateWirelessGatewayFromCertificateRequest,
      DisassociateWirelessGatewayFromCertificateResponse
    ](
      "disassociateWirelessGatewayFromCertificate",
      api.disassociateWirelessGatewayFromCertificate
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.wrap
      )
      .provideEnvironment(r)
    def deleteDestination(
        request: zio.aws.iotwireless.model.DeleteDestinationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteDestinationResponse.ReadOnly
    ] =
      asyncRequestResponse[DeleteDestinationRequest, DeleteDestinationResponse](
        "deleteDestination",
        api.deleteDestination
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.DeleteDestinationResponse.wrap)
        .provideEnvironment(r)
    def updateMulticastGroup(
        request: zio.aws.iotwireless.model.UpdateMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateMulticastGroupRequest,
      UpdateMulticastGroupResponse
    ]("updateMulticastGroup", api.updateMulticastGroup)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.UpdateMulticastGroupResponse.wrap)
      .provideEnvironment(r)
    def getMulticastGroup(
        request: zio.aws.iotwireless.model.GetMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly
    ] =
      asyncRequestResponse[GetMulticastGroupRequest, GetMulticastGroupResponse](
        "getMulticastGroup",
        api.getMulticastGroup
      )(request.buildAwsValue())
        .map(zio.aws.iotwireless.model.GetMulticastGroupResponse.wrap)
        .provideEnvironment(r)
    def updateWirelessGateway(
        request: zio.aws.iotwireless.model.UpdateWirelessGatewayRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateWirelessGatewayRequest,
      UpdateWirelessGatewayResponse
    ]("updateWirelessGateway", api.updateWirelessGateway)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.wrap)
      .provideEnvironment(r)
    def getWirelessGatewayTask(
        request: zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayTaskRequest,
      GetWirelessGatewayTaskResponse
    ]("getWirelessGatewayTask", api.getWirelessGatewayTask)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.wrap)
      .provideEnvironment(r)
    def startBulkAssociateWirelessDeviceWithMulticastGroup(
        request: zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      StartBulkAssociateWirelessDeviceWithMulticastGroupRequest,
      StartBulkAssociateWirelessDeviceWithMulticastGroupResponse
    ](
      "startBulkAssociateWirelessDeviceWithMulticastGroup",
      api.startBulkAssociateWirelessDeviceWithMulticastGroup
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.wrap
      )
      .provideEnvironment(r)
    def getWirelessGatewayFirmwareInformation(
        request: zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayFirmwareInformationRequest,
      GetWirelessGatewayFirmwareInformationResponse
    ](
      "getWirelessGatewayFirmwareInformation",
      api.getWirelessGatewayFirmwareInformation
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.wrap
      )
      .provideEnvironment(r)
    def getNetworkAnalyzerConfiguration(
        request: zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetNetworkAnalyzerConfigurationRequest,
      GetNetworkAnalyzerConfigurationResponse
    ]("getNetworkAnalyzerConfiguration", api.getNetworkAnalyzerConfiguration)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.wrap
    ).provideEnvironment(r)
    def listMulticastGroupsByFuotaTask(
        request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListMulticastGroupsByFuotaTaskRequest,
      ListMulticastGroupsByFuotaTaskResponse,
      MulticastGroupByFuotaTask
    ](
      "listMulticastGroupsByFuotaTask",
      api.listMulticastGroupsByFuotaTask,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multicastGroupList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotwireless.model.MulticastGroupByFuotaTask.wrap(item)
      )
      .provideEnvironment(r)
    def listMulticastGroupsByFuotaTaskPaginated(
        request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      ListMulticastGroupsByFuotaTaskRequest,
      ListMulticastGroupsByFuotaTaskResponse
    ]("listMulticastGroupsByFuotaTask", api.listMulticastGroupsByFuotaTask)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.wrap)
      .provideEnvironment(r)
    def createMulticastGroup(
        request: zio.aws.iotwireless.model.CreateMulticastGroupRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateMulticastGroupRequest,
      CreateMulticastGroupResponse
    ]("createMulticastGroup", api.createMulticastGroup)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.CreateMulticastGroupResponse.wrap)
      .provideEnvironment(r)
    def createWirelessGatewayTaskDefinition(
        request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateWirelessGatewayTaskDefinitionRequest,
      CreateWirelessGatewayTaskDefinitionResponse
    ](
      "createWirelessGatewayTaskDefinition",
      api.createWirelessGatewayTaskDefinition
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.wrap
      )
      .provideEnvironment(r)
    def listWirelessDevices(
        request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListWirelessDevicesRequest,
      ListWirelessDevicesResponse,
      WirelessDeviceStatistics
    ](
      "listWirelessDevices",
      api.listWirelessDevices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.wirelessDeviceList().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.iotwireless.model.WirelessDeviceStatistics.wrap(item)
      )
      .provideEnvironment(r)
    def listWirelessDevicesPaginated(
        request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListWirelessDevicesRequest,
      ListWirelessDevicesResponse
    ]("listWirelessDevices", api.listWirelessDevices)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListWirelessDevicesResponse.wrap)
      .provideEnvironment(r)
    def getServiceEndpoint(
        request: zio.aws.iotwireless.model.GetServiceEndpointRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      GetServiceEndpointRequest,
      GetServiceEndpointResponse
    ]("getServiceEndpoint", api.getServiceEndpoint)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.GetServiceEndpointResponse.wrap)
      .provideEnvironment(r)
    def getWirelessGatewayTaskDefinition(
        request: zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayTaskDefinitionRequest,
      GetWirelessGatewayTaskDefinitionResponse
    ]("getWirelessGatewayTaskDefinition", api.getWirelessGatewayTaskDefinition)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.wrap
    ).provideEnvironment(r)
    def associateWirelessDeviceWithThing(
        request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateWirelessDeviceWithThingRequest,
      AssociateWirelessDeviceWithThingResponse
    ]("associateWirelessDeviceWithThing", api.associateWirelessDeviceWithThing)(
      request.buildAwsValue()
    ).map(
      zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.wrap
    ).provideEnvironment(r)
    def getWirelessDeviceStatistics(
        request: zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessDeviceStatisticsRequest,
      GetWirelessDeviceStatisticsResponse
    ]("getWirelessDeviceStatistics", api.getWirelessDeviceStatistics)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.wrap)
      .provideEnvironment(r)
    def getDeviceProfile(
        request: zio.aws.iotwireless.model.GetDeviceProfileRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly
    ] = asyncRequestResponse[GetDeviceProfileRequest, GetDeviceProfileResponse](
      "getDeviceProfile",
      api.getDeviceProfile
    )(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.GetDeviceProfileResponse.wrap)
      .provideEnvironment(r)
    def getWirelessGateway(
        request: zio.aws.iotwireless.model.GetWirelessGatewayRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      GetWirelessGatewayRequest,
      GetWirelessGatewayResponse
    ]("getWirelessGateway", api.getWirelessGateway)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.GetWirelessGatewayResponse.wrap)
      .provideEnvironment(r)
    def disassociateWirelessGatewayFromThing(
        request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateWirelessGatewayFromThingRequest,
      DisassociateWirelessGatewayFromThingResponse
    ](
      "disassociateWirelessGatewayFromThing",
      api.disassociateWirelessGatewayFromThing
    )(request.buildAwsValue())
      .map(
        zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.wrap
      )
      .provideEnvironment(r)
    def resetResourceLogLevel(
        request: zio.aws.iotwireless.model.ResetResourceLogLevelRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ResetResourceLogLevelResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetResourceLogLevelRequest,
      ResetResourceLogLevelResponse
    ]("resetResourceLogLevel", api.resetResourceLogLevel)(
      request.buildAwsValue()
    ).map(zio.aws.iotwireless.model.ResetResourceLogLevelResponse.wrap)
      .provideEnvironment(r)
    def listQueuedMessages(
        request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListQueuedMessagesRequest,
      ListQueuedMessagesResponse,
      DownlinkQueueMessage
    ](
      "listQueuedMessages",
      api.listQueuedMessages,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.downlinkQueueMessagesList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iotwireless.model.DownlinkQueueMessage.wrap(item))
      .provideEnvironment(r)
    def listQueuedMessagesPaginated(
        request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListQueuedMessagesRequest,
      ListQueuedMessagesResponse
    ]("listQueuedMessages", api.listQueuedMessages)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListQueuedMessagesResponse.wrap)
      .provideEnvironment(r)
    def listDeviceProfiles(
        request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceProfile.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListDeviceProfilesRequest,
      ListDeviceProfilesResponse,
      DeviceProfile
    ](
      "listDeviceProfiles",
      api.listDeviceProfiles,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.deviceProfileList().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.iotwireless.model.DeviceProfile.wrap(item))
      .provideEnvironment(r)
    def listDeviceProfilesPaginated(
        request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListDeviceProfilesRequest,
      ListDeviceProfilesResponse
    ]("listDeviceProfiles", api.listDeviceProfiles)(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.ListDeviceProfilesResponse.wrap)
      .provideEnvironment(r)
    def deleteFuotaTask(
        request: zio.aws.iotwireless.model.DeleteFuotaTaskRequest
    ): IO[
      AwsError,
      zio.aws.iotwireless.model.DeleteFuotaTaskResponse.ReadOnly
    ] = asyncRequestResponse[DeleteFuotaTaskRequest, DeleteFuotaTaskResponse](
      "deleteFuotaTask",
      api.deleteFuotaTask
    )(request.buildAwsValue())
      .map(zio.aws.iotwireless.model.DeleteFuotaTaskResponse.wrap)
      .provideEnvironment(r)
  }
  def cancelMulticastGroupSession(
      request: zio.aws.iotwireless.model.CancelMulticastGroupSessionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelMulticastGroupSession(request))
  def getWirelessGatewayStatistics(
      request: zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGatewayStatistics(request))
  def createWirelessGateway(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWirelessGateway(request))
  def listWirelessGatewayTaskDefinitions(
      request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listWirelessGatewayTaskDefinitions(request))
  def listWirelessGatewayTaskDefinitionsPaginated(
      request: zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWirelessGatewayTaskDefinitionsPaginated(request))
  def associateWirelessGatewayWithCertificate(
      request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWirelessGatewayWithCertificate(request))
  def listServiceProfiles(
      request: zio.aws.iotwireless.model.ListServiceProfilesRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ServiceProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listServiceProfiles(request))
  def listServiceProfilesPaginated(
      request: zio.aws.iotwireless.model.ListServiceProfilesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listServiceProfilesPaginated(request))
  def testWirelessDevice(
      request: zio.aws.iotwireless.model.TestWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testWirelessDevice(request))
  def deleteDeviceProfile(
      request: zio.aws.iotwireless.model.DeleteDeviceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteDeviceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDeviceProfile(request))
  def deleteServiceProfile(
      request: zio.aws.iotwireless.model.DeleteServiceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteServiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteServiceProfile(request))
  def getMulticastGroupSession(
      request: zio.aws.iotwireless.model.GetMulticastGroupSessionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMulticastGroupSession(request))
  def updateFuotaTask(
      request: zio.aws.iotwireless.model.UpdateFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateFuotaTask(request))
  def getLogLevelsByResourceTypes(
      request: zio.aws.iotwireless.model.GetLogLevelsByResourceTypesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLogLevelsByResourceTypes(request))
  def getResourceEventConfiguration(
      request: zio.aws.iotwireless.model.GetResourceEventConfigurationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceEventConfiguration(request))
  def listFuotaTasks(
      request: zio.aws.iotwireless.model.ListFuotaTasksRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.FuotaTask.ReadOnly
  ] = ZStream.serviceWithStream(_.listFuotaTasks(request))
  def listFuotaTasksPaginated(
      request: zio.aws.iotwireless.model.ListFuotaTasksRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listFuotaTasksPaginated(request))
  def createDestination(
      request: zio.aws.iotwireless.model.CreateDestinationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDestination(request))
  def resetAllResourceLogLevels(
      request: zio.aws.iotwireless.model.ResetAllResourceLogLevelsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetAllResourceLogLevels(request))
  def listDestinations(
      request: zio.aws.iotwireless.model.ListDestinationsRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.Destinations.ReadOnly
  ] = ZStream.serviceWithStream(_.listDestinations(request))
  def listDestinationsPaginated(
      request: zio.aws.iotwireless.model.ListDestinationsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDestinationsPaginated(request))
  def updateResourceEventConfiguration(
      request: zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateResourceEventConfiguration(request))
  def createServiceProfile(
      request: zio.aws.iotwireless.model.CreateServiceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createServiceProfile(request))
  def getServiceProfile(
      request: zio.aws.iotwireless.model.GetServiceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceProfile(request))
  def putResourceLogLevel(
      request: zio.aws.iotwireless.model.PutResourceLogLevelRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.PutResourceLogLevelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putResourceLogLevel(request))
  def startBulkDisassociateWirelessDeviceFromMulticastGroup(
      request: zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.startBulkDisassociateWirelessDeviceFromMulticastGroup(request)
  )
  def disassociateWirelessDeviceFromMulticastGroup(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.disassociateWirelessDeviceFromMulticastGroup(request))
  def disassociateWirelessDeviceFromFuotaTask(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateWirelessDeviceFromFuotaTask(request))
  def getWirelessDevice(
      request: zio.aws.iotwireless.model.GetWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessDevice(request))
  def getResourceLogLevel(
      request: zio.aws.iotwireless.model.GetResourceLogLevelRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getResourceLogLevel(request))
  def disassociateAwsAccountFromPartnerAccount(
      request: zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateAwsAccountFromPartnerAccount(request))
  def disassociateWirelessDeviceFromThing(
      request: zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateWirelessDeviceFromThing(request))
  def deleteWirelessDevice(
      request: zio.aws.iotwireless.model.DeleteWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWirelessDevice(request))
  def createWirelessDevice(
      request: zio.aws.iotwireless.model.CreateWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWirelessDevice(request))
  def startFuotaTask(
      request: zio.aws.iotwireless.model.StartFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.StartFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startFuotaTask(request))
  def deleteWirelessGatewayTask(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWirelessGatewayTask(request))
  def associateWirelessDeviceWithFuotaTask(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWirelessDeviceWithFuotaTask(request))
  def updatePartnerAccount(
      request: zio.aws.iotwireless.model.UpdatePartnerAccountRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdatePartnerAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePartnerAccount(request))
  def deleteWirelessGateway(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWirelessGateway(request))
  def sendDataToMulticastGroup(
      request: zio.aws.iotwireless.model.SendDataToMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendDataToMulticastGroup(request))
  def getFuotaTask(request: zio.aws.iotwireless.model.GetFuotaTaskRequest): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFuotaTask(request))
  def deleteMulticastGroup(
      request: zio.aws.iotwireless.model.DeleteMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMulticastGroup(request))
  def updateDestination(
      request: zio.aws.iotwireless.model.UpdateDestinationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDestination(request))
  def startMulticastGroupSession(
      request: zio.aws.iotwireless.model.StartMulticastGroupSessionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startMulticastGroupSession(request))
  def untagResource(
      request: zio.aws.iotwireless.model.UntagResourceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createFuotaTask(
      request: zio.aws.iotwireless.model.CreateFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFuotaTask(request))
  def associateWirelessDeviceWithMulticastGroup(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWirelessDeviceWithMulticastGroup(request))
  def getWirelessGatewayCertificate(
      request: zio.aws.iotwireless.model.GetWirelessGatewayCertificateRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGatewayCertificate(request))
  def associateWirelessGatewayWithThing(
      request: zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWirelessGatewayWithThing(request))
  def listWirelessGateways(
      request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
  ] = ZStream.serviceWithStream(_.listWirelessGateways(request))
  def listWirelessGatewaysPaginated(
      request: zio.aws.iotwireless.model.ListWirelessGatewaysRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWirelessGatewaysPaginated(request))
  def updateWirelessDevice(
      request: zio.aws.iotwireless.model.UpdateWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWirelessDevice(request))
  def sendDataToWirelessDevice(
      request: zio.aws.iotwireless.model.SendDataToWirelessDeviceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendDataToWirelessDevice(request))
  def createWirelessGatewayTask(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWirelessGatewayTask(request))
  def updateLogLevelsByResourceTypes(
      request: zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLogLevelsByResourceTypes(request))
  def updateNetworkAnalyzerConfiguration(
      request: zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateNetworkAnalyzerConfiguration(request))
  def disassociateMulticastGroupFromFuotaTask(
      request: zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateMulticastGroupFromFuotaTask(request))
  def associateAwsAccountWithPartnerAccount(
      request: zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateAwsAccountWithPartnerAccount(request))
  def listTagsForResource(
      request: zio.aws.iotwireless.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def deleteQueuedMessages(
      request: zio.aws.iotwireless.model.DeleteQueuedMessagesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueuedMessages(request))
  def getPartnerAccount(
      request: zio.aws.iotwireless.model.GetPartnerAccountRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPartnerAccount(request))
  def getDestination(
      request: zio.aws.iotwireless.model.GetDestinationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDestination(request))
  def associateMulticastGroupWithFuotaTask(
      request: zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateMulticastGroupWithFuotaTask(request))
  def tagResource(
      request: zio.aws.iotwireless.model.TagResourceRequest
  ): ZIO[zio.aws.iotwireless.IotWireless, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createDeviceProfile(
      request: zio.aws.iotwireless.model.CreateDeviceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDeviceProfile(request))
  def deleteWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteWirelessGatewayTaskDefinition(request))
  def listPartnerAccounts(
      request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
  ] = ZStream.serviceWithStream(_.listPartnerAccounts(request))
  def listPartnerAccountsPaginated(
      request: zio.aws.iotwireless.model.ListPartnerAccountsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPartnerAccountsPaginated(request))
  def listMulticastGroups(
      request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.MulticastGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.listMulticastGroups(request))
  def listMulticastGroupsPaginated(
      request: zio.aws.iotwireless.model.ListMulticastGroupsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMulticastGroupsPaginated(request))
  def disassociateWirelessGatewayFromCertificate(
      request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateWirelessGatewayFromCertificate(request))
  def deleteDestination(
      request: zio.aws.iotwireless.model.DeleteDestinationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDestination(request))
  def updateMulticastGroup(
      request: zio.aws.iotwireless.model.UpdateMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMulticastGroup(request))
  def getMulticastGroup(
      request: zio.aws.iotwireless.model.GetMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getMulticastGroup(request))
  def updateWirelessGateway(
      request: zio.aws.iotwireless.model.UpdateWirelessGatewayRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateWirelessGateway(request))
  def getWirelessGatewayTask(
      request: zio.aws.iotwireless.model.GetWirelessGatewayTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGatewayTask(request))
  def startBulkAssociateWirelessDeviceWithMulticastGroup(
      request: zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.startBulkAssociateWirelessDeviceWithMulticastGroup(request)
  )
  def getWirelessGatewayFirmwareInformation(
      request: zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGatewayFirmwareInformation(request))
  def getNetworkAnalyzerConfiguration(
      request: zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkAnalyzerConfiguration(request))
  def listMulticastGroupsByFuotaTask(
      request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
  ] = ZStream.serviceWithStream(_.listMulticastGroupsByFuotaTask(request))
  def listMulticastGroupsByFuotaTaskPaginated(
      request: zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMulticastGroupsByFuotaTaskPaginated(request))
  def createMulticastGroup(
      request: zio.aws.iotwireless.model.CreateMulticastGroupRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMulticastGroup(request))
  def createWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createWirelessGatewayTaskDefinition(request))
  def listWirelessDevices(
      request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
  ] = ZStream.serviceWithStream(_.listWirelessDevices(request))
  def listWirelessDevicesPaginated(
      request: zio.aws.iotwireless.model.ListWirelessDevicesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listWirelessDevicesPaginated(request))
  def getServiceEndpoint(
      request: zio.aws.iotwireless.model.GetServiceEndpointRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getServiceEndpoint(request))
  def getWirelessGatewayTaskDefinition(
      request: zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGatewayTaskDefinition(request))
  def associateWirelessDeviceWithThing(
      request: zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateWirelessDeviceWithThing(request))
  def getWirelessDeviceStatistics(
      request: zio.aws.iotwireless.model.GetWirelessDeviceStatisticsRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessDeviceStatistics(request))
  def getDeviceProfile(
      request: zio.aws.iotwireless.model.GetDeviceProfileRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDeviceProfile(request))
  def getWirelessGateway(
      request: zio.aws.iotwireless.model.GetWirelessGatewayRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getWirelessGateway(request))
  def disassociateWirelessGatewayFromThing(
      request: zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateWirelessGatewayFromThing(request))
  def resetResourceLogLevel(
      request: zio.aws.iotwireless.model.ResetResourceLogLevelRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ResetResourceLogLevelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetResourceLogLevel(request))
  def listQueuedMessages(
      request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueuedMessages(request))
  def listQueuedMessagesPaginated(
      request: zio.aws.iotwireless.model.ListQueuedMessagesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueuedMessagesPaginated(request))
  def listDeviceProfiles(
      request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
  ): ZStream[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeviceProfile.ReadOnly
  ] = ZStream.serviceWithStream(_.listDeviceProfiles(request))
  def listDeviceProfilesPaginated(
      request: zio.aws.iotwireless.model.ListDeviceProfilesRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDeviceProfilesPaginated(request))
  def deleteFuotaTask(
      request: zio.aws.iotwireless.model.DeleteFuotaTaskRequest
  ): ZIO[
    zio.aws.iotwireless.IotWireless,
    AwsError,
    zio.aws.iotwireless.model.DeleteFuotaTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFuotaTask(request))
}
