package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class WirelessGatewayEventLogOption(
    event: zio.aws.iotwireless.model.WirelessGatewayEvent,
    logLevel: zio.aws.iotwireless.model.LogLevel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption = {
    import WirelessGatewayEventLogOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption
      .builder()
      .event(event.unwrap)
      .logLevel(logLevel.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly =
    zio.aws.iotwireless.model.WirelessGatewayEventLogOption
      .wrap(buildAwsValue())
}
object WirelessGatewayEventLogOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessGatewayEventLogOption =
      zio.aws.iotwireless.model.WirelessGatewayEventLogOption(event, logLevel)
    def event: zio.aws.iotwireless.model.WirelessGatewayEvent
    def logLevel: zio.aws.iotwireless.model.LogLevel
    def getEvent
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessGatewayEvent] =
      ZIO.succeed(event)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iotwireless.model.LogLevel] =
      ZIO.succeed(logLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption
  ) extends zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly {
    override val event: zio.aws.iotwireless.model.WirelessGatewayEvent =
      zio.aws.iotwireless.model.WirelessGatewayEvent.wrap(impl.event())
    override val logLevel: zio.aws.iotwireless.model.LogLevel =
      zio.aws.iotwireless.model.LogLevel.wrap(impl.logLevel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption
  ): zio.aws.iotwireless.model.WirelessGatewayEventLogOption.ReadOnly =
    new Wrapper(impl)
}
