package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  PartnerAccountArn,
  Fingerprint,
  AmazonId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SidewalkAccountInfoWithFingerprint(
    amazonId: Option[AmazonId] = None,
    fingerprint: Option[Fingerprint] = None,
    arn: Option[PartnerAccountArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint = {
    import SidewalkAccountInfoWithFingerprint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        fingerprint.map(value => Fingerprint.unwrap(value): java.lang.String)
      )(_.fingerprint)
      .optionallyWith(
        arn.map(value => PartnerAccountArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly =
    zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint
      .wrap(buildAwsValue())
}
object SidewalkAccountInfoWithFingerprint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint =
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint(
        amazonId.map(value => value),
        fingerprint.map(value => value),
        arn.map(value => value)
      )
    def amazonId: Option[AmazonId]
    def fingerprint: Option[Fingerprint]
    def arn: Option[PartnerAccountArn]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getFingerprint: ZIO[Any, AwsError, Fingerprint] =
      AwsError.unwrapOptionField("fingerprint", fingerprint)
    def getArn: ZIO[Any, AwsError, PartnerAccountArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ) extends zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly {
    override val amazonId: Option[AmazonId] = scala
      .Option(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val fingerprint: Option[Fingerprint] = scala
      .Option(impl.fingerprint())
      .map(value => zio.aws.iotwireless.model.primitives.Fingerprint(value))
    override val arn: Option[PartnerAccountArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.PartnerAccountArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfoWithFingerprint
  ): zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly =
    new Wrapper(impl)
}
