package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DevEui
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANListDevice(devEui: Option[DevEui] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice = {
    import LoRaWANListDevice.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice
      .builder()
      .optionallyWith(
        devEui.map(value => DevEui.unwrap(value): java.lang.String)
      )(_.devEui)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANListDevice.wrap(buildAwsValue())
}
object LoRaWANListDevice {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANListDevice =
      zio.aws.iotwireless.model.LoRaWANListDevice(devEui.map(value => value))
    def devEui: Option[DevEui]
    def getDevEui: ZIO[Any, AwsError, DevEui] =
      AwsError.unwrapOptionField("devEui", devEui)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice
  ) extends zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly {
    override val devEui: Option[DevEui] = scala
      .Option(impl.devEui())
      .map(value => zio.aws.iotwireless.model.primitives.DevEui(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice
  ): zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly = new Wrapper(impl)
}
