package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.GatewayEui
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANGatewayMetadata(
    gatewayEui: Option[GatewayEui] = None,
    snr: Option[Double] = None,
    rssi: Option[Double] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata = {
    import LoRaWANGatewayMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata
      .builder()
      .optionallyWith(
        gatewayEui.map(value => GatewayEui.unwrap(value): java.lang.String)
      )(_.gatewayEui)
      .optionallyWith(snr.map(value => value: java.lang.Double))(_.snr)
      .optionallyWith(rssi.map(value => value: java.lang.Double))(_.rssi)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGatewayMetadata.wrap(buildAwsValue())
}
object LoRaWANGatewayMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGatewayMetadata =
      zio.aws.iotwireless.model.LoRaWANGatewayMetadata(
        gatewayEui.map(value => value),
        snr.map(value => value),
        rssi.map(value => value)
      )
    def gatewayEui: Option[GatewayEui]
    def snr: Option[Double]
    def rssi: Option[Double]
    def getGatewayEui: ZIO[Any, AwsError, GatewayEui] =
      AwsError.unwrapOptionField("gatewayEui", gatewayEui)
    def getSnr: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("snr", snr)
    def getRssi: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("rssi", rssi)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata
  ) extends zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly {
    override val gatewayEui: Option[GatewayEui] = scala
      .Option(impl.gatewayEui())
      .map(value => zio.aws.iotwireless.model.primitives.GatewayEui(value))
    override val snr: Option[Double] =
      scala.Option(impl.snr()).map(value => value: Double)
    override val rssi: Option[Double] =
      scala.Option(impl.rssi()).map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata
  ): zio.aws.iotwireless.model.LoRaWANGatewayMetadata.ReadOnly = new Wrapper(
    impl
  )
}
