package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  SubBand,
  NetId,
  JoinEui,
  GatewayEui,
  RfRegion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANGateway(
    gatewayEui: Option[GatewayEui] = None,
    rfRegion: Option[RfRegion] = None,
    joinEuiFilters: Option[Iterable[Iterable[JoinEui]]] = None,
    netIdFilters: Option[Iterable[NetId]] = None,
    subBands: Option[Iterable[SubBand]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway = {
    import LoRaWANGateway.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
      .builder()
      .optionallyWith(
        gatewayEui.map(value => GatewayEui.unwrap(value): java.lang.String)
      )(_.gatewayEui)
      .optionallyWith(
        rfRegion.map(value => RfRegion.unwrap(value): java.lang.String)
      )(_.rfRegion)
      .optionallyWith(
        joinEuiFilters.map(value =>
          value.map { item =>
            item.map { item =>
              JoinEui.unwrap(item): java.lang.String
            }.asJavaCollection
          }.asJavaCollection
        )
      )(_.joinEuiFilters)
      .optionallyWith(
        netIdFilters.map(value =>
          value.map { item =>
            NetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.netIdFilters)
      .optionallyWith(
        subBands.map(value =>
          value.map { item =>
            SubBand.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.subBands)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANGateway.wrap(buildAwsValue())
}
object LoRaWANGateway {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANGateway =
      zio.aws.iotwireless.model.LoRaWANGateway(
        gatewayEui.map(value => value),
        rfRegion.map(value => value),
        joinEuiFilters.map(value => value),
        netIdFilters.map(value => value),
        subBands.map(value => value)
      )
    def gatewayEui: Option[GatewayEui]
    def rfRegion: Option[RfRegion]
    def joinEuiFilters: Option[List[List[JoinEui]]]
    def netIdFilters: Option[List[NetId]]
    def subBands: Option[List[SubBand]]
    def getGatewayEui: ZIO[Any, AwsError, GatewayEui] =
      AwsError.unwrapOptionField("gatewayEui", gatewayEui)
    def getRfRegion: ZIO[Any, AwsError, RfRegion] =
      AwsError.unwrapOptionField("rfRegion", rfRegion)
    def getJoinEuiFilters: ZIO[Any, AwsError, List[List[JoinEui]]] =
      AwsError.unwrapOptionField("joinEuiFilters", joinEuiFilters)
    def getNetIdFilters: ZIO[Any, AwsError, List[NetId]] =
      AwsError.unwrapOptionField("netIdFilters", netIdFilters)
    def getSubBands: ZIO[Any, AwsError, List[SubBand]] =
      AwsError.unwrapOptionField("subBands", subBands)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ) extends zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly {
    override val gatewayEui: Option[GatewayEui] = scala
      .Option(impl.gatewayEui())
      .map(value => zio.aws.iotwireless.model.primitives.GatewayEui(value))
    override val rfRegion: Option[RfRegion] = scala
      .Option(impl.rfRegion())
      .map(value => zio.aws.iotwireless.model.primitives.RfRegion(value))
    override val joinEuiFilters: Option[List[List[JoinEui]]] = scala
      .Option(impl.joinEuiFilters())
      .map(value =>
        value.asScala.map { item =>
          item.asScala.map { item =>
            zio.aws.iotwireless.model.primitives.JoinEui(item)
          }.toList
        }.toList
      )
    override val netIdFilters: Option[List[NetId]] = scala
      .Option(impl.netIdFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.NetId(item)
        }.toList
      )
    override val subBands: Option[List[SubBand]] = scala
      .Option(impl.subBands())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.primitives.SubBand(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANGateway
  ): zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly = new Wrapper(impl)
}
