package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewaysResponse(
    nextToken: Option[NextToken] = None,
    wirelessGatewayList: Option[
      Iterable[zio.aws.iotwireless.model.WirelessGatewayStatistics]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse = {
    import ListWirelessGatewaysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        wirelessGatewayList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.wirelessGatewayList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewaysResponse.wrap(buildAwsValue())
}
object ListWirelessGatewaysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListWirelessGatewaysResponse =
      zio.aws.iotwireless.model.ListWirelessGatewaysResponse(
        nextToken.map(value => value),
        wirelessGatewayList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def wirelessGatewayList: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWirelessGatewayList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField("wirelessGatewayList", wirelessGatewayList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ) extends zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val wirelessGatewayList: Option[
      List[zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly]
    ] = scala
      .Option(impl.wirelessGatewayList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessGatewayStatistics.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewaysResponse
  ): zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly =
    new Wrapper(impl)
}
