package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListQueuedMessagesResponse(
    nextToken: Option[NextToken] = None,
    downlinkQueueMessagesList: Option[
      Iterable[zio.aws.iotwireless.model.DownlinkQueueMessage]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse = {
    import ListQueuedMessagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        downlinkQueueMessagesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.downlinkQueueMessagesList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly =
    zio.aws.iotwireless.model.ListQueuedMessagesResponse.wrap(buildAwsValue())
}
object ListQueuedMessagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListQueuedMessagesResponse =
      zio.aws.iotwireless.model.ListQueuedMessagesResponse(
        nextToken.map(value => value),
        downlinkQueueMessagesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def downlinkQueueMessagesList
        : Option[List[zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDownlinkQueueMessagesList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "downlinkQueueMessagesList",
      downlinkQueueMessagesList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse
  ) extends zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val downlinkQueueMessagesList: Option[
      List[zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly]
    ] = scala
      .Option(impl.downlinkQueueMessagesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.DownlinkQueueMessage.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse
  ): zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly =
    new Wrapper(impl)
}
