package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  MaxResults,
  NextToken,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListQueuedMessagesRequest(
    id: WirelessDeviceId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None,
    wirelessDeviceType: Option[zio.aws.iotwireless.model.WirelessDeviceType] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest = {
    import ListQueuedMessagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(wirelessDeviceType.map(value => value.unwrap))(
        _.wirelessDeviceType
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly =
    zio.aws.iotwireless.model.ListQueuedMessagesRequest.wrap(buildAwsValue())
}
object ListQueuedMessagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListQueuedMessagesRequest =
      zio.aws.iotwireless.model.ListQueuedMessagesRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value),
        wirelessDeviceType.map(value => value)
      )
    def id: WirelessDeviceId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def wirelessDeviceType: Option[zio.aws.iotwireless.model.WirelessDeviceType]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getWirelessDeviceType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("wirelessDeviceType", wirelessDeviceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ) extends zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
    override val wirelessDeviceType
        : Option[zio.aws.iotwireless.model.WirelessDeviceType] = scala
      .Option(impl.wirelessDeviceType())
      .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest
  ): zio.aws.iotwireless.model.ListQueuedMessagesRequest.ReadOnly = new Wrapper(
    impl
  )
}
