package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListPartnerAccountsResponse(
    nextToken: Option[NextToken] = None,
    sidewalk: Option[
      Iterable[zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse = {
    import ListPartnerAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        sidewalk.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListPartnerAccountsResponse.wrap(buildAwsValue())
}
object ListPartnerAccountsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListPartnerAccountsResponse =
      zio.aws.iotwireless.model.ListPartnerAccountsResponse(
        nextToken.map(value => value),
        sidewalk.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def sidewalk: Option[List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSidewalk: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ) extends zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val sidewalk: Option[List[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]] = scala
      .Option(impl.sidewalk())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListPartnerAccountsResponse
  ): zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly =
    new Wrapper(impl)
}
