package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMulticastGroupsResponse(
    nextToken: Option[NextToken] = None,
    multicastGroupList: Option[
      Iterable[zio.aws.iotwireless.model.MulticastGroup]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse = {
    import ListMulticastGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        multicastGroupList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.multicastGroupList)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListMulticastGroupsResponse.wrap(buildAwsValue())
}
object ListMulticastGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListMulticastGroupsResponse =
      zio.aws.iotwireless.model.ListMulticastGroupsResponse(
        nextToken.map(value => value),
        multicastGroupList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def multicastGroupList
        : Option[List[zio.aws.iotwireless.model.MulticastGroup.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMulticastGroupList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.MulticastGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("multicastGroupList", multicastGroupList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse
  ) extends zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val multicastGroupList
        : Option[List[zio.aws.iotwireless.model.MulticastGroup.ReadOnly]] =
      scala
        .Option(impl.multicastGroupList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotwireless.model.MulticastGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsResponse
  ): zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
