package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListDestinationsResponse(
    nextToken: Option[NextToken] = None,
    destinationList: Option[Iterable[zio.aws.iotwireless.model.Destinations]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse = {
    import ListDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        destinationList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinationList)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListDestinationsResponse.wrap(buildAwsValue())
}
object ListDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.ListDestinationsResponse =
      zio.aws.iotwireless.model.ListDestinationsResponse(
        nextToken.map(value => value),
        destinationList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def destinationList
        : Option[List[zio.aws.iotwireless.model.Destinations.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getDestinationList: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.Destinations.ReadOnly
    ]] = AwsError.unwrapOptionField("destinationList", destinationList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse
  ) extends zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val destinationList
        : Option[List[zio.aws.iotwireless.model.Destinations.ReadOnly]] = scala
      .Option(impl.destinationList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.Destinations.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse
  ): zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
