package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetWirelessDeviceStatisticsResponse(
    wirelessDeviceId: Option[WirelessDeviceId] = None,
    lastUplinkReceivedAt: Option[ISODateTimeString] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANDeviceMetadata] = None,
    sidewalk: Option[zio.aws.iotwireless.model.SidewalkDeviceMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse = {
    import GetWirelessDeviceStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
      .builder()
      .optionallyWith(
        wirelessDeviceId.map(value =>
          WirelessDeviceId.unwrap(value): java.lang.String
        )
      )(_.wirelessDeviceId)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse
      .wrap(buildAwsValue())
}
object GetWirelessDeviceStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse =
      zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse(
        wirelessDeviceId.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable)
      )
    def wirelessDeviceId: Option[WirelessDeviceId]
    def lastUplinkReceivedAt: Option[ISODateTimeString]
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly]
    def sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly]
    def getWirelessDeviceId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("wirelessDeviceId", wirelessDeviceId)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
  ) extends zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly {
    override val wirelessDeviceId: Option[WirelessDeviceId] = scala
      .Option(impl.wirelessDeviceId())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
    override val lastUplinkReceivedAt: Option[ISODateTimeString] = scala
      .Option(impl.lastUplinkReceivedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANDeviceMetadata.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANDeviceMetadata.wrap(value)
        )
    override val sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkDeviceMetadata.ReadOnly] =
      scala
        .Option(impl.sidewalk())
        .map(value =>
          zio.aws.iotwireless.model.SidewalkDeviceMetadata.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessDeviceStatisticsResponse
  ): zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
