package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.MulticastGroupId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetMulticastGroupRequest(id: MulticastGroupId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest = {
    import GetMulticastGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest
      .builder()
      .id(MulticastGroupId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetMulticastGroupRequest.ReadOnly =
    zio.aws.iotwireless.model.GetMulticastGroupRequest.wrap(buildAwsValue())
}
object GetMulticastGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetMulticastGroupRequest =
      zio.aws.iotwireless.model.GetMulticastGroupRequest(id)
    def id: MulticastGroupId
    def getId: ZIO[Any, Nothing, MulticastGroupId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest
  ) extends zio.aws.iotwireless.model.GetMulticastGroupRequest.ReadOnly {
    override val id: MulticastGroupId =
      zio.aws.iotwireless.model.primitives.MulticastGroupId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetMulticastGroupRequest
  ): zio.aws.iotwireless.model.GetMulticastGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
