package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait FuotaTaskStatus {
  def unwrap: software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus
}
object FuotaTaskStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus
  ): zio.aws.iotwireless.model.FuotaTaskStatus = value match {
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.FUOTA_SESSION_WAITING =>
      val r = FuotaSession_Waiting
      r
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.IN_FUOTA_SESSION =>
      val r = In_FuotaSession
      r
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.FUOTA_DONE =>
      val r = FuotaDone
      r
    case software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.DELETE_WAITING =>
      val r = Delete_Waiting
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.PENDING
  }
  case object FuotaSession_Waiting
      extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.FUOTA_SESSION_WAITING
  }
  case object In_FuotaSession
      extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.IN_FUOTA_SESSION
  }
  case object FuotaDone extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.FUOTA_DONE
  }
  case object Delete_Waiting extends zio.aws.iotwireless.model.FuotaTaskStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus =
      software.amazon.awssdk.services.iotwireless.model.FuotaTaskStatus.DELETE_WAITING
  }
}
