package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.FPort
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FPorts(
    fuota: Option[FPort] = None,
    multicast: Option[FPort] = None,
    clockSync: Option[FPort] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.FPorts = {
    import FPorts.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.FPorts
      .builder()
      .optionallyWith(fuota.map(value => FPort.unwrap(value): Integer))(_.fuota)
      .optionallyWith(multicast.map(value => FPort.unwrap(value): Integer))(
        _.multicast
      )
      .optionallyWith(clockSync.map(value => FPort.unwrap(value): Integer))(
        _.clockSync
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.FPorts.ReadOnly =
    zio.aws.iotwireless.model.FPorts.wrap(buildAwsValue())
}
object FPorts {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.FPorts
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.FPorts =
      zio.aws.iotwireless.model.FPorts(
        fuota.map(value => value),
        multicast.map(value => value),
        clockSync.map(value => value)
      )
    def fuota: Option[FPort]
    def multicast: Option[FPort]
    def clockSync: Option[FPort]
    def getFuota: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fuota", fuota)
    def getMulticast: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("multicast", multicast)
    def getClockSync: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("clockSync", clockSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.FPorts
  ) extends zio.aws.iotwireless.model.FPorts.ReadOnly {
    override val fuota: Option[FPort] = scala
      .Option(impl.fuota())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val multicast: Option[FPort] = scala
      .Option(impl.multicast())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
    override val clockSync: Option[FPort] = scala
      .Option(impl.clockSync())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.FPorts
  ): zio.aws.iotwireless.model.FPorts.ReadOnly = new Wrapper(impl)
}
