package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  ISODateTimeString,
  TransmitMode,
  MessageId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DownlinkQueueMessage(
    messageId: Option[MessageId] = None,
    transmitMode: Option[TransmitMode] = None,
    receivedAt: Option[ISODateTimeString] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage = {
    import DownlinkQueueMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .optionallyWith(
        transmitMode.map(value => TransmitMode.unwrap(value): Integer)
      )(_.transmitMode)
      .optionallyWith(
        receivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.receivedAt)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly =
    zio.aws.iotwireless.model.DownlinkQueueMessage.wrap(buildAwsValue())
}
object DownlinkQueueMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DownlinkQueueMessage =
      zio.aws.iotwireless.model.DownlinkQueueMessage(
        messageId.map(value => value),
        transmitMode.map(value => value),
        receivedAt.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def messageId: Option[MessageId]
    def transmitMode: Option[TransmitMode]
    def receivedAt: Option[ISODateTimeString]
    def loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getTransmitMode: ZIO[Any, AwsError, TransmitMode] =
      AwsError.unwrapOptionField("transmitMode", transmitMode)
    def getReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("receivedAt", receivedAt)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage
  ) extends zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly {
    override val messageId: Option[MessageId] = scala
      .Option(impl.messageId())
      .map(value => zio.aws.iotwireless.model.primitives.MessageId(value))
    override val transmitMode: Option[TransmitMode] = scala
      .Option(impl.transmitMode())
      .map(value => zio.aws.iotwireless.model.primitives.TransmitMode(value))
    override val receivedAt: Option[ISODateTimeString] = scala
      .Option(impl.receivedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANSendDataToDevice.ReadOnly] =
      scala
        .Option(impl.loRaWAN())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANSendDataToDevice.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DownlinkQueueMessage
  ): zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly = new Wrapper(impl)
}
