package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DestinationName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDestinationRequest(name: DestinationName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest = {
    import DeleteDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest
      .builder()
      .name(DestinationName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.DeleteDestinationRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteDestinationRequest.wrap(buildAwsValue())
}
object DeleteDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteDestinationRequest =
      zio.aws.iotwireless.model.DeleteDestinationRequest(name)
    def name: DestinationName
    def getName: ZIO[Any, Nothing, DestinationName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest
  ) extends zio.aws.iotwireless.model.DeleteDestinationRequest.ReadOnly {
    override val name: DestinationName =
      zio.aws.iotwireless.model.primitives.DestinationName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteDestinationRequest
  ): zio.aws.iotwireless.model.DeleteDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
