package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.PartnerAccountArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociateAwsAccountWithPartnerAccountResponse(
    sidewalk: Option[zio.aws.iotwireless.model.SidewalkAccountInfo] = None,
    arn: Option[PartnerAccountArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse = {
    import AssociateAwsAccountWithPartnerAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(
        arn.map(value => PartnerAccountArn.unwrap(value): java.lang.String)
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly =
    zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
      .wrap(buildAwsValue())
}
object AssociateAwsAccountWithPartnerAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse =
      zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse(
        sidewalk.map(value => value.asEditable),
        arn.map(value => value)
      )
    def sidewalk: Option[zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly]
    def arn: Option[PartnerAccountArn]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getArn: ZIO[Any, AwsError, PartnerAccountArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ) extends zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly {
    override val sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly] = scala
      .Option(impl.sidewalk())
      .map(value => zio.aws.iotwireless.model.SidewalkAccountInfo.wrap(value))
    override val arn: Option[PartnerAccountArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.PartnerAccountArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse
  ): zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly =
    new Wrapper(impl)
}
