package zio.aws.iotwireless
import zio.aws.iotwireless.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient
import zio.aws.core.AwsError
import zio.aws.iotwireless.model.{
  GetWirelessGatewayTaskDefinitionRequest,
  UpdateMulticastGroupRequest,
  SendDataToWirelessDeviceRequest,
  TestWirelessDeviceRequest,
  DeleteFuotaTaskRequest,
  UpdateNetworkAnalyzerConfigurationRequest,
  DeleteWirelessGatewayTaskDefinitionRequest,
  CreateWirelessDeviceRequest,
  GetDeviceProfileRequest,
  CreateFuotaTaskRequest,
  CancelMulticastGroupSessionRequest,
  DisassociateWirelessGatewayFromThingRequest,
  DisassociateWirelessDeviceFromFuotaTaskRequest,
  DisassociateWirelessDeviceFromThingRequest,
  GetNetworkAnalyzerConfigurationRequest,
  ListWirelessGatewayTaskDefinitionsRequest,
  UpdateDestinationRequest,
  UpdateResourceEventConfigurationRequest,
  GetPartnerAccountRequest,
  UpdatePartnerAccountRequest,
  StartBulkAssociateWirelessDeviceWithMulticastGroupRequest,
  GetFuotaTaskRequest,
  AssociateAwsAccountWithPartnerAccountRequest,
  GetLogLevelsByResourceTypesRequest,
  DisassociateWirelessDeviceFromMulticastGroupRequest,
  CreateDestinationRequest,
  AssociateWirelessDeviceWithMulticastGroupRequest,
  AssociateWirelessDeviceWithThingRequest,
  GetMulticastGroupSessionRequest,
  UpdateWirelessDeviceRequest,
  ListMulticastGroupsRequest,
  DeleteQueuedMessagesRequest,
  UpdateFuotaTaskRequest,
  ListTagsForResourceRequest,
  CreateWirelessGatewayTaskDefinitionRequest,
  DeleteWirelessGatewayTaskRequest,
  ListQueuedMessagesRequest,
  ListFuotaTasksRequest,
  StartFuotaTaskRequest,
  GetWirelessGatewayCertificateRequest,
  DeleteDeviceProfileRequest,
  GetResourceEventConfigurationRequest,
  CreateDeviceProfileRequest,
  CreateWirelessGatewayRequest,
  DeleteDestinationRequest,
  ListDestinationsRequest,
  DeleteWirelessGatewayRequest,
  AssociateMulticastGroupWithFuotaTaskRequest,
  DisassociateMulticastGroupFromFuotaTaskRequest,
  ListPartnerAccountsRequest,
  CreateServiceProfileRequest,
  GetWirelessGatewayTaskRequest,
  SendDataToMulticastGroupRequest,
  GetResourceLogLevelRequest,
  DeleteMulticastGroupRequest,
  GetDestinationRequest,
  ListDeviceProfilesRequest,
  CreateMulticastGroupRequest,
  GetServiceProfileRequest,
  ListWirelessDevicesRequest,
  ListServiceProfilesRequest,
  PutResourceLogLevelRequest,
  ListMulticastGroupsByFuotaTaskRequest,
  UpdateLogLevelsByResourceTypesRequest,
  GetWirelessGatewayStatisticsRequest,
  UpdateWirelessGatewayRequest,
  UntagResourceRequest,
  DeleteWirelessDeviceRequest,
  GetWirelessDeviceStatisticsRequest,
  DeleteServiceProfileRequest,
  GetWirelessGatewayRequest,
  ResetAllResourceLogLevelsRequest,
  AssociateWirelessGatewayWithCertificateRequest,
  CreateWirelessGatewayTaskRequest,
  ResetResourceLogLevelRequest,
  AssociateWirelessGatewayWithThingRequest,
  GetServiceEndpointRequest,
  StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest,
  GetWirelessGatewayFirmwareInformationRequest,
  DisassociateWirelessGatewayFromCertificateRequest,
  AssociateWirelessDeviceWithFuotaTaskRequest,
  TagResourceRequest,
  ListWirelessGatewaysRequest,
  StartMulticastGroupSessionRequest,
  GetMulticastGroupRequest,
  DisassociateAwsAccountFromPartnerAccountRequest,
  GetWirelessDeviceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object IotWirelessMock extends Mock[IotWireless] {
  object CancelMulticastGroupSession
      extends Effect[
        CancelMulticastGroupSessionRequest,
        AwsError,
        zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.ReadOnly
      ]
  object GetWirelessGatewayStatistics
      extends Effect[
        GetWirelessGatewayStatisticsRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly
      ]
  object CreateWirelessGateway
      extends Effect[
        CreateWirelessGatewayRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly
      ]
  object ListWirelessGatewayTaskDefinitions
      extends Stream[
        ListWirelessGatewayTaskDefinitionsRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
      ]
  object ListWirelessGatewayTaskDefinitionsPaginated
      extends Effect[
        ListWirelessGatewayTaskDefinitionsRequest,
        AwsError,
        zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly
      ]
  object AssociateWirelessGatewayWithCertificate
      extends Effect[
        AssociateWirelessGatewayWithCertificateRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly
      ]
  object ListServiceProfiles
      extends Stream[
        ListServiceProfilesRequest,
        AwsError,
        zio.aws.iotwireless.model.ServiceProfile.ReadOnly
      ]
  object ListServiceProfilesPaginated
      extends Effect[
        ListServiceProfilesRequest,
        AwsError,
        zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly
      ]
  object TestWirelessDevice
      extends Effect[
        TestWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly
      ]
  object DeleteDeviceProfile
      extends Effect[
        DeleteDeviceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteDeviceProfileResponse.ReadOnly
      ]
  object DeleteServiceProfile
      extends Effect[
        DeleteServiceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteServiceProfileResponse.ReadOnly
      ]
  object GetMulticastGroupSession
      extends Effect[
        GetMulticastGroupSessionRequest,
        AwsError,
        zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.ReadOnly
      ]
  object UpdateFuotaTask
      extends Effect[
        UpdateFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateFuotaTaskResponse.ReadOnly
      ]
  object GetLogLevelsByResourceTypes
      extends Effect[
        GetLogLevelsByResourceTypesRequest,
        AwsError,
        zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly
      ]
  object GetResourceEventConfiguration
      extends Effect[
        GetResourceEventConfigurationRequest,
        AwsError,
        zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly
      ]
  object ListFuotaTasks
      extends Stream[
        ListFuotaTasksRequest,
        AwsError,
        zio.aws.iotwireless.model.FuotaTask.ReadOnly
      ]
  object ListFuotaTasksPaginated
      extends Effect[
        ListFuotaTasksRequest,
        AwsError,
        zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly
      ]
  object CreateDestination
      extends Effect[
        CreateDestinationRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly
      ]
  object ResetAllResourceLogLevels
      extends Effect[
        ResetAllResourceLogLevelsRequest,
        AwsError,
        zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.ReadOnly
      ]
  object ListDestinations
      extends Stream[
        ListDestinationsRequest,
        AwsError,
        zio.aws.iotwireless.model.Destinations.ReadOnly
      ]
  object ListDestinationsPaginated
      extends Effect[
        ListDestinationsRequest,
        AwsError,
        zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly
      ]
  object UpdateResourceEventConfiguration
      extends Effect[
        UpdateResourceEventConfigurationRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.ReadOnly
      ]
  object CreateServiceProfile
      extends Effect[
        CreateServiceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly
      ]
  object GetServiceProfile
      extends Effect[
        GetServiceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly
      ]
  object PutResourceLogLevel
      extends Effect[
        PutResourceLogLevelRequest,
        AwsError,
        zio.aws.iotwireless.model.PutResourceLogLevelResponse.ReadOnly
      ]
  object StartBulkDisassociateWirelessDeviceFromMulticastGroup
      extends Effect[
        StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
      ]
  object DisassociateWirelessDeviceFromMulticastGroup
      extends Effect[
        DisassociateWirelessDeviceFromMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
      ]
  object DisassociateWirelessDeviceFromFuotaTask
      extends Effect[
        DisassociateWirelessDeviceFromFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.ReadOnly
      ]
  object GetWirelessDevice
      extends Effect[
        GetWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly
      ]
  object GetResourceLogLevel
      extends Effect[
        GetResourceLogLevelRequest,
        AwsError,
        zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly
      ]
  object DisassociateAwsAccountFromPartnerAccount
      extends Effect[
        DisassociateAwsAccountFromPartnerAccountRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.ReadOnly
      ]
  object DisassociateWirelessDeviceFromThing
      extends Effect[
        DisassociateWirelessDeviceFromThingRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.ReadOnly
      ]
  object DeleteWirelessDevice
      extends Effect[
        DeleteWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.ReadOnly
      ]
  object CreateWirelessDevice
      extends Effect[
        CreateWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly
      ]
  object StartFuotaTask
      extends Effect[
        StartFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.StartFuotaTaskResponse.ReadOnly
      ]
  object DeleteWirelessGatewayTask
      extends Effect[
        DeleteWirelessGatewayTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.ReadOnly
      ]
  object AssociateWirelessDeviceWithFuotaTask
      extends Effect[
        AssociateWirelessDeviceWithFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.ReadOnly
      ]
  object UpdatePartnerAccount
      extends Effect[
        UpdatePartnerAccountRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdatePartnerAccountResponse.ReadOnly
      ]
  object DeleteWirelessGateway
      extends Effect[
        DeleteWirelessGatewayRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.ReadOnly
      ]
  object SendDataToMulticastGroup
      extends Effect[
        SendDataToMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly
      ]
  object GetFuotaTask
      extends Effect[
        GetFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly
      ]
  object DeleteMulticastGroup
      extends Effect[
        DeleteMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteMulticastGroupResponse.ReadOnly
      ]
  object UpdateDestination
      extends Effect[
        UpdateDestinationRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateDestinationResponse.ReadOnly
      ]
  object StartMulticastGroupSession
      extends Effect[
        StartMulticastGroupSessionRequest,
        AwsError,
        zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotwireless.model.UntagResourceResponse.ReadOnly
      ]
  object CreateFuotaTask
      extends Effect[
        CreateFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly
      ]
  object AssociateWirelessDeviceWithMulticastGroup
      extends Effect[
        AssociateWirelessDeviceWithMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
      ]
  object GetWirelessGatewayCertificate
      extends Effect[
        GetWirelessGatewayCertificateRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly
      ]
  object AssociateWirelessGatewayWithThing
      extends Effect[
        AssociateWirelessGatewayWithThingRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.ReadOnly
      ]
  object ListWirelessGateways
      extends Stream[
        ListWirelessGatewaysRequest,
        AwsError,
        zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
      ]
  object ListWirelessGatewaysPaginated
      extends Effect[
        ListWirelessGatewaysRequest,
        AwsError,
        zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly
      ]
  object UpdateWirelessDevice
      extends Effect[
        UpdateWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.ReadOnly
      ]
  object SendDataToWirelessDevice
      extends Effect[
        SendDataToWirelessDeviceRequest,
        AwsError,
        zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly
      ]
  object CreateWirelessGatewayTask
      extends Effect[
        CreateWirelessGatewayTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly
      ]
  object UpdateLogLevelsByResourceTypes
      extends Effect[
        UpdateLogLevelsByResourceTypesRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.ReadOnly
      ]
  object UpdateNetworkAnalyzerConfiguration
      extends Effect[
        UpdateNetworkAnalyzerConfigurationRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.ReadOnly
      ]
  object DisassociateMulticastGroupFromFuotaTask
      extends Effect[
        DisassociateMulticastGroupFromFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.ReadOnly
      ]
  object AssociateAwsAccountWithPartnerAccount
      extends Effect[
        AssociateAwsAccountWithPartnerAccountRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotwireless.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteQueuedMessages
      extends Effect[
        DeleteQueuedMessagesRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.ReadOnly
      ]
  object GetPartnerAccount
      extends Effect[
        GetPartnerAccountRequest,
        AwsError,
        zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly
      ]
  object GetDestination
      extends Effect[
        GetDestinationRequest,
        AwsError,
        zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly
      ]
  object AssociateMulticastGroupWithFuotaTask
      extends Effect[
        AssociateMulticastGroupWithFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object CreateDeviceProfile
      extends Effect[
        CreateDeviceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly
      ]
  object DeleteWirelessGatewayTaskDefinition
      extends Effect[
        DeleteWirelessGatewayTaskDefinitionRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.ReadOnly
      ]
  object ListPartnerAccounts
      extends Stream[
        ListPartnerAccountsRequest,
        AwsError,
        zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
      ]
  object ListPartnerAccountsPaginated
      extends Effect[
        ListPartnerAccountsRequest,
        AwsError,
        zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly
      ]
  object ListMulticastGroups
      extends Stream[
        ListMulticastGroupsRequest,
        AwsError,
        zio.aws.iotwireless.model.MulticastGroup.ReadOnly
      ]
  object ListMulticastGroupsPaginated
      extends Effect[
        ListMulticastGroupsRequest,
        AwsError,
        zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly
      ]
  object DisassociateWirelessGatewayFromCertificate
      extends Effect[
        DisassociateWirelessGatewayFromCertificateRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.ReadOnly
      ]
  object DeleteDestination
      extends Effect[
        DeleteDestinationRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteDestinationResponse.ReadOnly
      ]
  object UpdateMulticastGroup
      extends Effect[
        UpdateMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateMulticastGroupResponse.ReadOnly
      ]
  object GetMulticastGroup
      extends Effect[
        GetMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly
      ]
  object UpdateWirelessGateway
      extends Effect[
        UpdateWirelessGatewayRequest,
        AwsError,
        zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.ReadOnly
      ]
  object GetWirelessGatewayTask
      extends Effect[
        GetWirelessGatewayTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly
      ]
  object StartBulkAssociateWirelessDeviceWithMulticastGroup
      extends Effect[
        StartBulkAssociateWirelessDeviceWithMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
      ]
  object GetWirelessGatewayFirmwareInformation
      extends Effect[
        GetWirelessGatewayFirmwareInformationRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly
      ]
  object GetNetworkAnalyzerConfiguration
      extends Effect[
        GetNetworkAnalyzerConfigurationRequest,
        AwsError,
        zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly
      ]
  object ListMulticastGroupsByFuotaTask
      extends Stream[
        ListMulticastGroupsByFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
      ]
  object ListMulticastGroupsByFuotaTaskPaginated
      extends Effect[
        ListMulticastGroupsByFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly
      ]
  object CreateMulticastGroup
      extends Effect[
        CreateMulticastGroupRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly
      ]
  object CreateWirelessGatewayTaskDefinition
      extends Effect[
        CreateWirelessGatewayTaskDefinitionRequest,
        AwsError,
        zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly
      ]
  object ListWirelessDevices
      extends Stream[
        ListWirelessDevicesRequest,
        AwsError,
        zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
      ]
  object ListWirelessDevicesPaginated
      extends Effect[
        ListWirelessDevicesRequest,
        AwsError,
        zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly
      ]
  object GetServiceEndpoint
      extends Effect[
        GetServiceEndpointRequest,
        AwsError,
        zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly
      ]
  object GetWirelessGatewayTaskDefinition
      extends Effect[
        GetWirelessGatewayTaskDefinitionRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly
      ]
  object AssociateWirelessDeviceWithThing
      extends Effect[
        AssociateWirelessDeviceWithThingRequest,
        AwsError,
        zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.ReadOnly
      ]
  object GetWirelessDeviceStatistics
      extends Effect[
        GetWirelessDeviceStatisticsRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly
      ]
  object GetDeviceProfile
      extends Effect[
        GetDeviceProfileRequest,
        AwsError,
        zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly
      ]
  object GetWirelessGateway
      extends Effect[
        GetWirelessGatewayRequest,
        AwsError,
        zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly
      ]
  object DisassociateWirelessGatewayFromThing
      extends Effect[
        DisassociateWirelessGatewayFromThingRequest,
        AwsError,
        zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.ReadOnly
      ]
  object ResetResourceLogLevel
      extends Effect[
        ResetResourceLogLevelRequest,
        AwsError,
        zio.aws.iotwireless.model.ResetResourceLogLevelResponse.ReadOnly
      ]
  object ListQueuedMessages
      extends Stream[
        ListQueuedMessagesRequest,
        AwsError,
        zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
      ]
  object ListQueuedMessagesPaginated
      extends Effect[
        ListQueuedMessagesRequest,
        AwsError,
        zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly
      ]
  object ListDeviceProfiles
      extends Stream[
        ListDeviceProfilesRequest,
        AwsError,
        zio.aws.iotwireless.model.DeviceProfile.ReadOnly
      ]
  object ListDeviceProfilesPaginated
      extends Effect[
        ListDeviceProfilesRequest,
        AwsError,
        zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly
      ]
  object DeleteFuotaTask
      extends Effect[
        DeleteFuotaTaskRequest,
        AwsError,
        zio.aws.iotwireless.model.DeleteFuotaTaskResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IotWireless] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new IotWireless {
          val api: IotWirelessAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : IotWireless = this
          def cancelMulticastGroupSession(
              request: CancelMulticastGroupSessionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.CancelMulticastGroupSessionResponse.ReadOnly
          ] = proxy(CancelMulticastGroupSession, request)
          def getWirelessGatewayStatistics(
              request: GetWirelessGatewayStatisticsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayStatisticsResponse.ReadOnly
          ] = proxy(GetWirelessGatewayStatistics, request)
          def createWirelessGateway(request: CreateWirelessGatewayRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateWirelessGatewayResponse.ReadOnly
          ] = proxy(CreateWirelessGateway, request)
          def listWirelessGatewayTaskDefinitions(
              request: ListWirelessGatewayTaskDefinitionsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
          ] = rts.unsafeRun(proxy(ListWirelessGatewayTaskDefinitions, request))
          def listWirelessGatewayTaskDefinitionsPaginated(
              request: ListWirelessGatewayTaskDefinitionsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly
          ] = proxy(ListWirelessGatewayTaskDefinitionsPaginated, request)
          def associateWirelessGatewayWithCertificate(
              request: AssociateWirelessGatewayWithCertificateRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateWirelessGatewayWithCertificateResponse.ReadOnly
          ] = proxy(AssociateWirelessGatewayWithCertificate, request)
          def listServiceProfiles(request: ListServiceProfilesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.ServiceProfile.ReadOnly
          ] = rts.unsafeRun(proxy(ListServiceProfiles, request))
          def listServiceProfilesPaginated(
              request: ListServiceProfilesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListServiceProfilesResponse.ReadOnly
          ] = proxy(ListServiceProfilesPaginated, request)
          def testWirelessDevice(request: TestWirelessDeviceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.TestWirelessDeviceResponse.ReadOnly
          ] = proxy(TestWirelessDevice, request)
          def deleteDeviceProfile(request: DeleteDeviceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteDeviceProfileResponse.ReadOnly
          ] = proxy(DeleteDeviceProfile, request)
          def deleteServiceProfile(request: DeleteServiceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteServiceProfileResponse.ReadOnly
          ] = proxy(DeleteServiceProfile, request)
          def getMulticastGroupSession(
              request: GetMulticastGroupSessionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetMulticastGroupSessionResponse.ReadOnly
          ] = proxy(GetMulticastGroupSession, request)
          def updateFuotaTask(request: UpdateFuotaTaskRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateFuotaTaskResponse.ReadOnly
          ] = proxy(UpdateFuotaTask, request)
          def getLogLevelsByResourceTypes(
              request: GetLogLevelsByResourceTypesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetLogLevelsByResourceTypesResponse.ReadOnly
          ] = proxy(GetLogLevelsByResourceTypes, request)
          def getResourceEventConfiguration(
              request: GetResourceEventConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetResourceEventConfigurationResponse.ReadOnly
          ] = proxy(GetResourceEventConfiguration, request)
          def listFuotaTasks(request: ListFuotaTasksRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.FuotaTask.ReadOnly
          ] = rts.unsafeRun(proxy(ListFuotaTasks, request))
          def listFuotaTasksPaginated(request: ListFuotaTasksRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.ListFuotaTasksResponse.ReadOnly
          ] = proxy(ListFuotaTasksPaginated, request)
          def createDestination(request: CreateDestinationRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateDestinationResponse.ReadOnly
          ] = proxy(CreateDestination, request)
          def resetAllResourceLogLevels(
              request: ResetAllResourceLogLevelsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ResetAllResourceLogLevelsResponse.ReadOnly
          ] = proxy(ResetAllResourceLogLevels, request)
          def listDestinations(request: ListDestinationsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.Destinations.ReadOnly
          ] = rts.unsafeRun(proxy(ListDestinations, request))
          def listDestinationsPaginated(request: ListDestinationsRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.ListDestinationsResponse.ReadOnly
          ] = proxy(ListDestinationsPaginated, request)
          def updateResourceEventConfiguration(
              request: UpdateResourceEventConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateResourceEventConfigurationResponse.ReadOnly
          ] = proxy(UpdateResourceEventConfiguration, request)
          def createServiceProfile(request: CreateServiceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly
          ] = proxy(CreateServiceProfile, request)
          def getServiceProfile(request: GetServiceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetServiceProfileResponse.ReadOnly
          ] = proxy(GetServiceProfile, request)
          def putResourceLogLevel(request: PutResourceLogLevelRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.PutResourceLogLevelResponse.ReadOnly
          ] = proxy(PutResourceLogLevel, request)
          def startBulkDisassociateWirelessDeviceFromMulticastGroup(
              request: StartBulkDisassociateWirelessDeviceFromMulticastGroupRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.StartBulkDisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
          ] = proxy(
            StartBulkDisassociateWirelessDeviceFromMulticastGroup,
            request
          )
          def disassociateWirelessDeviceFromMulticastGroup(
              request: DisassociateWirelessDeviceFromMulticastGroupRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateWirelessDeviceFromMulticastGroupResponse.ReadOnly
          ] = proxy(DisassociateWirelessDeviceFromMulticastGroup, request)
          def disassociateWirelessDeviceFromFuotaTask(
              request: DisassociateWirelessDeviceFromFuotaTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateWirelessDeviceFromFuotaTaskResponse.ReadOnly
          ] = proxy(DisassociateWirelessDeviceFromFuotaTask, request)
          def getWirelessDevice(request: GetWirelessDeviceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessDeviceResponse.ReadOnly
          ] = proxy(GetWirelessDevice, request)
          def getResourceLogLevel(request: GetResourceLogLevelRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetResourceLogLevelResponse.ReadOnly
          ] = proxy(GetResourceLogLevel, request)
          def disassociateAwsAccountFromPartnerAccount(
              request: DisassociateAwsAccountFromPartnerAccountRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateAwsAccountFromPartnerAccountResponse.ReadOnly
          ] = proxy(DisassociateAwsAccountFromPartnerAccount, request)
          def disassociateWirelessDeviceFromThing(
              request: DisassociateWirelessDeviceFromThingRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateWirelessDeviceFromThingResponse.ReadOnly
          ] = proxy(DisassociateWirelessDeviceFromThing, request)
          def deleteWirelessDevice(request: DeleteWirelessDeviceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteWirelessDeviceResponse.ReadOnly
          ] = proxy(DeleteWirelessDevice, request)
          def createWirelessDevice(request: CreateWirelessDeviceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateWirelessDeviceResponse.ReadOnly
          ] = proxy(CreateWirelessDevice, request)
          def startFuotaTask(request: StartFuotaTaskRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.StartFuotaTaskResponse.ReadOnly
          ] = proxy(StartFuotaTask, request)
          def deleteWirelessGatewayTask(
              request: DeleteWirelessGatewayTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteWirelessGatewayTaskResponse.ReadOnly
          ] = proxy(DeleteWirelessGatewayTask, request)
          def associateWirelessDeviceWithFuotaTask(
              request: AssociateWirelessDeviceWithFuotaTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskResponse.ReadOnly
          ] = proxy(AssociateWirelessDeviceWithFuotaTask, request)
          def updatePartnerAccount(request: UpdatePartnerAccountRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdatePartnerAccountResponse.ReadOnly
          ] = proxy(UpdatePartnerAccount, request)
          def deleteWirelessGateway(request: DeleteWirelessGatewayRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteWirelessGatewayResponse.ReadOnly
          ] = proxy(DeleteWirelessGateway, request)
          def sendDataToMulticastGroup(
              request: SendDataToMulticastGroupRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.SendDataToMulticastGroupResponse.ReadOnly
          ] = proxy(SendDataToMulticastGroup, request)
          def getFuotaTask(request: GetFuotaTaskRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetFuotaTaskResponse.ReadOnly
          ] = proxy(GetFuotaTask, request)
          def deleteMulticastGroup(request: DeleteMulticastGroupRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteMulticastGroupResponse.ReadOnly
          ] = proxy(DeleteMulticastGroup, request)
          def updateDestination(request: UpdateDestinationRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateDestinationResponse.ReadOnly
          ] = proxy(UpdateDestination, request)
          def startMulticastGroupSession(
              request: StartMulticastGroupSessionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.StartMulticastGroupSessionResponse.ReadOnly
          ] = proxy(StartMulticastGroupSession, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def createFuotaTask(request: CreateFuotaTaskRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateFuotaTaskResponse.ReadOnly
          ] = proxy(CreateFuotaTask, request)
          def associateWirelessDeviceWithMulticastGroup(
              request: AssociateWirelessDeviceWithMulticastGroupRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
          ] = proxy(AssociateWirelessDeviceWithMulticastGroup, request)
          def getWirelessGatewayCertificate(
              request: GetWirelessGatewayCertificateRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayCertificateResponse.ReadOnly
          ] = proxy(GetWirelessGatewayCertificate, request)
          def associateWirelessGatewayWithThing(
              request: AssociateWirelessGatewayWithThingRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateWirelessGatewayWithThingResponse.ReadOnly
          ] = proxy(AssociateWirelessGatewayWithThing, request)
          def listWirelessGateways(
              request: ListWirelessGatewaysRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly
          ] = rts.unsafeRun(proxy(ListWirelessGateways, request))
          def listWirelessGatewaysPaginated(
              request: ListWirelessGatewaysRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListWirelessGatewaysResponse.ReadOnly
          ] = proxy(ListWirelessGatewaysPaginated, request)
          def updateWirelessDevice(request: UpdateWirelessDeviceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateWirelessDeviceResponse.ReadOnly
          ] = proxy(UpdateWirelessDevice, request)
          def sendDataToWirelessDevice(
              request: SendDataToWirelessDeviceRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.SendDataToWirelessDeviceResponse.ReadOnly
          ] = proxy(SendDataToWirelessDevice, request)
          def createWirelessGatewayTask(
              request: CreateWirelessGatewayTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateWirelessGatewayTaskResponse.ReadOnly
          ] = proxy(CreateWirelessGatewayTask, request)
          def updateLogLevelsByResourceTypes(
              request: UpdateLogLevelsByResourceTypesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateLogLevelsByResourceTypesResponse.ReadOnly
          ] = proxy(UpdateLogLevelsByResourceTypes, request)
          def updateNetworkAnalyzerConfiguration(
              request: UpdateNetworkAnalyzerConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateNetworkAnalyzerConfigurationResponse.ReadOnly
          ] = proxy(UpdateNetworkAnalyzerConfiguration, request)
          def disassociateMulticastGroupFromFuotaTask(
              request: DisassociateMulticastGroupFromFuotaTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateMulticastGroupFromFuotaTaskResponse.ReadOnly
          ] = proxy(DisassociateMulticastGroupFromFuotaTask, request)
          def associateAwsAccountWithPartnerAccount(
              request: AssociateAwsAccountWithPartnerAccountRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateAwsAccountWithPartnerAccountResponse.ReadOnly
          ] = proxy(AssociateAwsAccountWithPartnerAccount, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def deleteQueuedMessages(request: DeleteQueuedMessagesRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteQueuedMessagesResponse.ReadOnly
          ] = proxy(DeleteQueuedMessages, request)
          def getPartnerAccount(request: GetPartnerAccountRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly
          ] = proxy(GetPartnerAccount, request)
          def getDestination(request: GetDestinationRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetDestinationResponse.ReadOnly
          ] = proxy(GetDestination, request)
          def associateMulticastGroupWithFuotaTask(
              request: AssociateMulticastGroupWithFuotaTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateMulticastGroupWithFuotaTaskResponse.ReadOnly
          ] = proxy(AssociateMulticastGroupWithFuotaTask, request)
          def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
            proxy(TagResource, request)
          def createDeviceProfile(request: CreateDeviceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateDeviceProfileResponse.ReadOnly
          ] = proxy(CreateDeviceProfile, request)
          def deleteWirelessGatewayTaskDefinition(
              request: DeleteWirelessGatewayTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteWirelessGatewayTaskDefinitionResponse.ReadOnly
          ] = proxy(DeleteWirelessGatewayTaskDefinition, request)
          def listPartnerAccounts(request: ListPartnerAccountsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
          ] = rts.unsafeRun(proxy(ListPartnerAccounts, request))
          def listPartnerAccountsPaginated(
              request: ListPartnerAccountsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListPartnerAccountsResponse.ReadOnly
          ] = proxy(ListPartnerAccountsPaginated, request)
          def listMulticastGroups(request: ListMulticastGroupsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.MulticastGroup.ReadOnly
          ] = rts.unsafeRun(proxy(ListMulticastGroups, request))
          def listMulticastGroupsPaginated(
              request: ListMulticastGroupsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListMulticastGroupsResponse.ReadOnly
          ] = proxy(ListMulticastGroupsPaginated, request)
          def disassociateWirelessGatewayFromCertificate(
              request: DisassociateWirelessGatewayFromCertificateRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateWirelessGatewayFromCertificateResponse.ReadOnly
          ] = proxy(DisassociateWirelessGatewayFromCertificate, request)
          def deleteDestination(request: DeleteDestinationRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteDestinationResponse.ReadOnly
          ] = proxy(DeleteDestination, request)
          def updateMulticastGroup(request: UpdateMulticastGroupRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateMulticastGroupResponse.ReadOnly
          ] = proxy(UpdateMulticastGroup, request)
          def getMulticastGroup(request: GetMulticastGroupRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetMulticastGroupResponse.ReadOnly
          ] = proxy(GetMulticastGroup, request)
          def updateWirelessGateway(request: UpdateWirelessGatewayRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.UpdateWirelessGatewayResponse.ReadOnly
          ] = proxy(UpdateWirelessGateway, request)
          def getWirelessGatewayTask(
              request: GetWirelessGatewayTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayTaskResponse.ReadOnly
          ] = proxy(GetWirelessGatewayTask, request)
          def startBulkAssociateWirelessDeviceWithMulticastGroup(
              request: StartBulkAssociateWirelessDeviceWithMulticastGroupRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.StartBulkAssociateWirelessDeviceWithMulticastGroupResponse.ReadOnly
          ] = proxy(StartBulkAssociateWirelessDeviceWithMulticastGroup, request)
          def getWirelessGatewayFirmwareInformation(
              request: GetWirelessGatewayFirmwareInformationRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayFirmwareInformationResponse.ReadOnly
          ] = proxy(GetWirelessGatewayFirmwareInformation, request)
          def getNetworkAnalyzerConfiguration(
              request: GetNetworkAnalyzerConfigurationRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetNetworkAnalyzerConfigurationResponse.ReadOnly
          ] = proxy(GetNetworkAnalyzerConfiguration, request)
          def listMulticastGroupsByFuotaTask(
              request: ListMulticastGroupsByFuotaTaskRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.MulticastGroupByFuotaTask.ReadOnly
          ] = rts.unsafeRun(proxy(ListMulticastGroupsByFuotaTask, request))
          def listMulticastGroupsByFuotaTaskPaginated(
              request: ListMulticastGroupsByFuotaTaskRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskResponse.ReadOnly
          ] = proxy(ListMulticastGroupsByFuotaTaskPaginated, request)
          def createMulticastGroup(request: CreateMulticastGroupRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateMulticastGroupResponse.ReadOnly
          ] = proxy(CreateMulticastGroup, request)
          def createWirelessGatewayTaskDefinition(
              request: CreateWirelessGatewayTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.CreateWirelessGatewayTaskDefinitionResponse.ReadOnly
          ] = proxy(CreateWirelessGatewayTaskDefinition, request)
          def listWirelessDevices(request: ListWirelessDevicesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly
          ] = rts.unsafeRun(proxy(ListWirelessDevices, request))
          def listWirelessDevicesPaginated(
              request: ListWirelessDevicesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListWirelessDevicesResponse.ReadOnly
          ] = proxy(ListWirelessDevicesPaginated, request)
          def getServiceEndpoint(request: GetServiceEndpointRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetServiceEndpointResponse.ReadOnly
          ] = proxy(GetServiceEndpoint, request)
          def getWirelessGatewayTaskDefinition(
              request: GetWirelessGatewayTaskDefinitionRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionResponse.ReadOnly
          ] = proxy(GetWirelessGatewayTaskDefinition, request)
          def associateWirelessDeviceWithThing(
              request: AssociateWirelessDeviceWithThingRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.AssociateWirelessDeviceWithThingResponse.ReadOnly
          ] = proxy(AssociateWirelessDeviceWithThing, request)
          def getWirelessDeviceStatistics(
              request: GetWirelessDeviceStatisticsRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessDeviceStatisticsResponse.ReadOnly
          ] = proxy(GetWirelessDeviceStatistics, request)
          def getDeviceProfile(request: GetDeviceProfileRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetDeviceProfileResponse.ReadOnly
          ] = proxy(GetDeviceProfile, request)
          def getWirelessGateway(request: GetWirelessGatewayRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.GetWirelessGatewayResponse.ReadOnly
          ] = proxy(GetWirelessGateway, request)
          def disassociateWirelessGatewayFromThing(
              request: DisassociateWirelessGatewayFromThingRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.DisassociateWirelessGatewayFromThingResponse.ReadOnly
          ] = proxy(DisassociateWirelessGatewayFromThing, request)
          def resetResourceLogLevel(request: ResetResourceLogLevelRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.ResetResourceLogLevelResponse.ReadOnly
          ] = proxy(ResetResourceLogLevel, request)
          def listQueuedMessages(request: ListQueuedMessagesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.DownlinkQueueMessage.ReadOnly
          ] = rts.unsafeRun(proxy(ListQueuedMessages, request))
          def listQueuedMessagesPaginated(
              request: ListQueuedMessagesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListQueuedMessagesResponse.ReadOnly
          ] = proxy(ListQueuedMessagesPaginated, request)
          def listDeviceProfiles(request: ListDeviceProfilesRequest): ZStream[
            Any,
            AwsError,
            zio.aws.iotwireless.model.DeviceProfile.ReadOnly
          ] = rts.unsafeRun(proxy(ListDeviceProfiles, request))
          def listDeviceProfilesPaginated(
              request: ListDeviceProfilesRequest
          ): IO[
            AwsError,
            zio.aws.iotwireless.model.ListDeviceProfilesResponse.ReadOnly
          ] = proxy(ListDeviceProfilesPaginated, request)
          def deleteFuotaTask(request: DeleteFuotaTaskRequest): IO[
            AwsError,
            zio.aws.iotwireless.model.DeleteFuotaTaskResponse.ReadOnly
          ] = proxy(DeleteFuotaTask, request)
        }
      }
    }
    .toLayer
}
