package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{
  MulticastDeviceStatus,
  WirelessDeviceName,
  ISODateTimeString,
  McGroupId,
  WirelessDeviceId,
  WirelessDeviceArn,
  DestinationName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WirelessDeviceStatistics(
    arn: Option[WirelessDeviceArn] = None,
    id: Option[WirelessDeviceId] = None,
    `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType] = None,
    name: Option[WirelessDeviceName] = None,
    destinationName: Option[DestinationName] = None,
    lastUplinkReceivedAt: Option[ISODateTimeString] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANListDevice] = None,
    sidewalk: Option[zio.aws.iotwireless.model.SidewalkListDevice] = None,
    fuotaDeviceStatus: Option[zio.aws.iotwireless.model.FuotaDeviceStatus] =
      None,
    multicastDeviceStatus: Option[MulticastDeviceStatus] = None,
    mcGroupId: Option[McGroupId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics = {
    import WirelessDeviceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
      .builder()
      .optionallyWith(
        arn.map(value => WirelessDeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessDeviceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(fuotaDeviceStatus.map(value => value.unwrap))(
        _.fuotaDeviceStatus
      )
      .optionallyWith(
        multicastDeviceStatus.map(value =>
          MulticastDeviceStatus.unwrap(value): java.lang.String
        )
      )(_.multicastDeviceStatus)
      .optionallyWith(mcGroupId.map(value => McGroupId.unwrap(value): Integer))(
        _.mcGroupId
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly =
    zio.aws.iotwireless.model.WirelessDeviceStatistics.wrap(buildAwsValue())
}
object WirelessDeviceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessDeviceStatistics =
      zio.aws.iotwireless.model.WirelessDeviceStatistics(
        arn.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        destinationName.map(value => value),
        lastUplinkReceivedAt.map(value => value),
        loRaWAN.map(value => value.asEditable),
        sidewalk.map(value => value.asEditable),
        fuotaDeviceStatus.map(value => value),
        multicastDeviceStatus.map(value => value),
        mcGroupId.map(value => value)
      )
    def arn: Option[WirelessDeviceArn]
    def id: Option[WirelessDeviceId]
    def `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType]
    def name: Option[WirelessDeviceName]
    def destinationName: Option[DestinationName]
    def lastUplinkReceivedAt: Option[ISODateTimeString]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly]
    def sidewalk: Option[zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly]
    def fuotaDeviceStatus: Option[zio.aws.iotwireless.model.FuotaDeviceStatus]
    def multicastDeviceStatus: Option[MulticastDeviceStatus]
    def mcGroupId: Option[McGroupId]
    def getArn: ZIO[Any, AwsError, WirelessDeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessDeviceId] =
      AwsError.unwrapOptionField("id", id)
    def getType
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.WirelessDeviceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getFuotaDeviceStatus
        : ZIO[Any, AwsError, zio.aws.iotwireless.model.FuotaDeviceStatus] =
      AwsError.unwrapOptionField("fuotaDeviceStatus", fuotaDeviceStatus)
    def getMulticastDeviceStatus: ZIO[Any, AwsError, MulticastDeviceStatus] =
      AwsError.unwrapOptionField("multicastDeviceStatus", multicastDeviceStatus)
    def getMcGroupId: ZIO[Any, AwsError, McGroupId] =
      AwsError.unwrapOptionField("mcGroupId", mcGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ) extends zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly {
    override val arn: Option[WirelessDeviceArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceArn(value)
      )
    override val id: Option[WirelessDeviceId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceId(value)
      )
    override val `type`: Option[zio.aws.iotwireless.model.WirelessDeviceType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.iotwireless.model.WirelessDeviceType.wrap(value))
    override val name: Option[WirelessDeviceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val destinationName: Option[DestinationName] = scala
      .Option(impl.destinationName())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val lastUplinkReceivedAt: Option[ISODateTimeString] = scala
      .Option(impl.lastUplinkReceivedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANListDevice.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANListDevice.wrap(value))
    override val sidewalk
        : Option[zio.aws.iotwireless.model.SidewalkListDevice.ReadOnly] = scala
      .Option(impl.sidewalk())
      .map(value => zio.aws.iotwireless.model.SidewalkListDevice.wrap(value))
    override val fuotaDeviceStatus
        : Option[zio.aws.iotwireless.model.FuotaDeviceStatus] = scala
      .Option(impl.fuotaDeviceStatus())
      .map(value => zio.aws.iotwireless.model.FuotaDeviceStatus.wrap(value))
    override val multicastDeviceStatus: Option[MulticastDeviceStatus] = scala
      .Option(impl.multicastDeviceStatus())
      .map(value =>
        zio.aws.iotwireless.model.primitives.MulticastDeviceStatus(value)
      )
    override val mcGroupId: Option[McGroupId] = scala
      .Option(impl.mcGroupId())
      .map(value => zio.aws.iotwireless.model.primitives.McGroupId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceStatistics
  ): zio.aws.iotwireless.model.WirelessDeviceStatistics.ReadOnly = new Wrapper(
    impl
  )
}
