package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WirelessDeviceLogOption(
    `type`: zio.aws.iotwireless.model.WirelessDeviceType,
    logLevel: zio.aws.iotwireless.model.LogLevel,
    events: Option[
      Iterable[zio.aws.iotwireless.model.WirelessDeviceEventLogOption]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption = {
    import WirelessDeviceLogOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption
      .builder()
      .`type`(`type`.unwrap)
      .logLevel(logLevel.unwrap)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly =
    zio.aws.iotwireless.model.WirelessDeviceLogOption.wrap(buildAwsValue())
}
object WirelessDeviceLogOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessDeviceLogOption =
      zio.aws.iotwireless.model.WirelessDeviceLogOption(
        `type`,
        logLevel,
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: zio.aws.iotwireless.model.WirelessDeviceType
    def logLevel: zio.aws.iotwireless.model.LogLevel
    def events: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly]
    ]
    def getType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.WirelessDeviceType] =
      ZIO.succeed(`type`)
    def getLogLevel: ZIO[Any, Nothing, zio.aws.iotwireless.model.LogLevel] =
      ZIO.succeed(logLevel)
    def getEvents: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly
    ]] = AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption
  ) extends zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly {
    override val `type`: zio.aws.iotwireless.model.WirelessDeviceType =
      zio.aws.iotwireless.model.WirelessDeviceType.wrap(impl.`type`())
    override val logLevel: zio.aws.iotwireless.model.LogLevel =
      zio.aws.iotwireless.model.LogLevel.wrap(impl.logLevel())
    override val events: Option[
      List[zio.aws.iotwireless.model.WirelessDeviceEventLogOption.ReadOnly]
    ] = scala
      .Option(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.WirelessDeviceEventLogOption.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessDeviceLogOption
  ): zio.aws.iotwireless.model.WirelessDeviceLogOption.ReadOnly = new Wrapper(
    impl
  )
}
