package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayTaskDefinitionArn,
  WirelessGatewayTaskDefinitionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateWirelessGatewayTaskEntry(
    id: Option[WirelessGatewayTaskDefinitionId] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry] =
      None,
    arn: Option[WirelessGatewayTaskDefinitionArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry = {
    import UpdateWirelessGatewayTaskEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
      .builder()
      .optionallyWith(
        id.map(value =>
          WirelessGatewayTaskDefinitionId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        arn.map(value =>
          WirelessGatewayTaskDefinitionArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry
      .wrap(buildAwsValue())
}
object UpdateWirelessGatewayTaskEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry =
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry(
        id.map(value => value),
        loRaWAN.map(value => value.asEditable),
        arn.map(value => value)
      )
    def id: Option[WirelessGatewayTaskDefinitionId]
    def loRaWAN: Option[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ]
    def arn: Option[WirelessGatewayTaskDefinitionArn]
    def getId: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionId] =
      AwsError.unwrapOptionField("id", id)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getArn: ZIO[Any, AwsError, WirelessGatewayTaskDefinitionArn] =
      AwsError.unwrapOptionField("arn", arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ) extends zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly {
    override val id: Option[WirelessGatewayTaskDefinitionId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionId(value)
      )
    override val loRaWAN: Option[
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly
    ] = scala
      .Option(impl.loRaWAN())
      .map(value =>
        zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.wrap(value)
      )
    override val arn: Option[WirelessGatewayTaskDefinitionArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives
          .WirelessGatewayTaskDefinitionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessGatewayTaskEntry
  ): zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly =
    new Wrapper(impl)
}
