package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  Description,
  WirelessDeviceName,
  DestinationName,
  WirelessDeviceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateWirelessDeviceRequest(
    id: WirelessDeviceId,
    destinationName: Option[DestinationName] = None,
    name: Option[WirelessDeviceName] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANUpdateDevice] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest = {
    import UpdateWirelessDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
      .builder()
      .id(WirelessDeviceId.unwrap(id): java.lang.String)
      .optionallyWith(
        destinationName.map(value =>
          DestinationName.unwrap(value): java.lang.String
        )
      )(_.destinationName)
      .optionallyWith(
        name.map(value => WirelessDeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.wrap(buildAwsValue())
}
object UpdateWirelessDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.UpdateWirelessDeviceRequest =
      zio.aws.iotwireless.model.UpdateWirelessDeviceRequest(
        id,
        destinationName.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable)
      )
    def id: WirelessDeviceId
    def destinationName: Option[DestinationName]
    def name: Option[WirelessDeviceName]
    def description: Option[Description]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly]
    def getId: ZIO[Any, Nothing, WirelessDeviceId] = ZIO.succeed(id)
    def getDestinationName: ZIO[Any, AwsError, DestinationName] =
      AwsError.unwrapOptionField("destinationName", destinationName)
    def getName: ZIO[Any, AwsError, WirelessDeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ) extends zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly {
    override val id: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives.WirelessDeviceId(impl.id())
    override val destinationName: Option[DestinationName] = scala
      .Option(impl.destinationName())
      .map(value => zio.aws.iotwireless.model.primitives.DestinationName(value))
    override val name: Option[WirelessDeviceName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessDeviceName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANUpdateDevice.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANUpdateDevice.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateWirelessDeviceRequest
  ): zio.aws.iotwireless.model.UpdateWirelessDeviceRequest.ReadOnly =
    new Wrapper(impl)
}
