package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.Identifier
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateResourceEventConfigurationRequest(
    identifier: Identifier,
    identifierType: zio.aws.iotwireless.model.IdentifierType,
    partnerType: Option[
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = None,
    deviceRegistrationState: Option[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
    ] = None,
    proximity: Option[zio.aws.iotwireless.model.ProximityEventConfiguration] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest = {
    import UpdateResourceEventConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .identifierType(identifierType.unwrap)
      .optionallyWith(partnerType.map(value => value.unwrap))(_.partnerType)
      .optionallyWith(
        deviceRegistrationState.map(value => value.buildAwsValue())
      )(_.deviceRegistrationState)
      .optionallyWith(proximity.map(value => value.buildAwsValue()))(
        _.proximity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest.ReadOnly =
    zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateResourceEventConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest =
      zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest(
        identifier,
        identifierType,
        partnerType.map(value => value),
        deviceRegistrationState.map(value => value.asEditable),
        proximity.map(value => value.asEditable)
      )
    def identifier: Identifier
    def identifierType: zio.aws.iotwireless.model.IdentifierType
    def partnerType
        : Option[zio.aws.iotwireless.model.EventNotificationPartnerType]
    def deviceRegistrationState: Option[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ]
    def proximity
        : Option[zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly]
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getIdentifierType
        : ZIO[Any, Nothing, zio.aws.iotwireless.model.IdentifierType] =
      ZIO.succeed(identifierType)
    def getPartnerType: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.EventNotificationPartnerType
    ] = AwsError.unwrapOptionField("partnerType", partnerType)
    def getDeviceRegistrationState: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deviceRegistrationState",
      deviceRegistrationState
    )
    def getProximity: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("proximity", proximity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest
  ) extends zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.iotwireless.model.primitives.Identifier(impl.identifier())
    override val identifierType: zio.aws.iotwireless.model.IdentifierType =
      zio.aws.iotwireless.model.IdentifierType.wrap(impl.identifierType())
    override val partnerType
        : Option[zio.aws.iotwireless.model.EventNotificationPartnerType] = scala
      .Option(impl.partnerType())
      .map(value =>
        zio.aws.iotwireless.model.EventNotificationPartnerType.wrap(value)
      )
    override val deviceRegistrationState: Option[
      zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration.ReadOnly
    ] = scala
      .Option(impl.deviceRegistrationState())
      .map(value =>
        zio.aws.iotwireless.model.DeviceRegistrationStateEventConfiguration
          .wrap(value)
      )
    override val proximity: Option[
      zio.aws.iotwireless.model.ProximityEventConfiguration.ReadOnly
    ] = scala
      .Option(impl.proximity())
      .map(value =>
        zio.aws.iotwireless.model.ProximityEventConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.UpdateResourceEventConfigurationRequest
  ): zio.aws.iotwireless.model.UpdateResourceEventConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
