package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{AppServerPrivateKey, AmazonId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SidewalkAccountInfo(
    amazonId: Option[AmazonId] = None,
    appServerPrivateKey: Option[AppServerPrivateKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo = {
    import SidewalkAccountInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo
      .builder()
      .optionallyWith(
        amazonId.map(value => AmazonId.unwrap(value): java.lang.String)
      )(_.amazonId)
      .optionallyWith(
        appServerPrivateKey.map(value =>
          AppServerPrivateKey.unwrap(value): java.lang.String
        )
      )(_.appServerPrivateKey)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly =
    zio.aws.iotwireless.model.SidewalkAccountInfo.wrap(buildAwsValue())
}
object SidewalkAccountInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.SidewalkAccountInfo =
      zio.aws.iotwireless.model.SidewalkAccountInfo(
        amazonId.map(value => value),
        appServerPrivateKey.map(value => value)
      )
    def amazonId: Option[AmazonId]
    def appServerPrivateKey: Option[AppServerPrivateKey]
    def getAmazonId: ZIO[Any, AwsError, AmazonId] =
      AwsError.unwrapOptionField("amazonId", amazonId)
    def getAppServerPrivateKey: ZIO[Any, AwsError, AppServerPrivateKey] =
      AwsError.unwrapOptionField("appServerPrivateKey", appServerPrivateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo
  ) extends zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly {
    override val amazonId: Option[AmazonId] = scala
      .Option(impl.amazonId())
      .map(value => zio.aws.iotwireless.model.primitives.AmazonId(value))
    override val appServerPrivateKey: Option[AppServerPrivateKey] = scala
      .Option(impl.appServerPrivateKey())
      .map(value =>
        zio.aws.iotwireless.model.primitives.AppServerPrivateKey(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.SidewalkAccountInfo
  ): zio.aws.iotwireless.model.SidewalkAccountInfo.ReadOnly = new Wrapper(impl)
}
