package zio.aws.iotwireless.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANUpdateGatewayTaskEntry(
    currentVersion: Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      None,
    updateVersion: Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry = {
    import LoRaWANUpdateGatewayTaskEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
      .builder()
      .optionallyWith(currentVersion.map(value => value.buildAwsValue()))(
        _.currentVersion
      )
      .optionallyWith(updateVersion.map(value => value.buildAwsValue()))(
        _.updateVersion
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
      .wrap(buildAwsValue())
}
object LoRaWANUpdateGatewayTaskEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry =
      zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry(
        currentVersion.map(value => value.asEditable),
        updateVersion.map(value => value.asEditable)
      )
    def currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def updateVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly]
    def getCurrentVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getUpdateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly
    ] = AwsError.unwrapOptionField("updateVersion", updateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ) extends zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly {
    override val currentVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      scala
        .Option(impl.currentVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
    override val updateVersion
        : Option[zio.aws.iotwireless.model.LoRaWANGatewayVersion.ReadOnly] =
      scala
        .Option(impl.updateVersion())
        .map(value =>
          zio.aws.iotwireless.model.LoRaWANGatewayVersion.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANUpdateGatewayTaskEntry
  ): zio.aws.iotwireless.model.LoRaWANUpdateGatewayTaskEntry.ReadOnly =
    new Wrapper(impl)
}
