package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.FPort
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LoRaWANMulticastMetadata(fPort: Option[FPort] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata = {
    import LoRaWANMulticastMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
      .builder()
      .optionallyWith(fPort.map(value => FPort.unwrap(value): Integer))(_.fPort)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly =
    zio.aws.iotwireless.model.LoRaWANMulticastMetadata.wrap(buildAwsValue())
}
object LoRaWANMulticastMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.LoRaWANMulticastMetadata =
      zio.aws.iotwireless.model
        .LoRaWANMulticastMetadata(fPort.map(value => value))
    def fPort: Option[FPort]
    def getFPort: ZIO[Any, AwsError, FPort] =
      AwsError.unwrapOptionField("fPort", fPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ) extends zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly {
    override val fPort: Option[FPort] = scala
      .Option(impl.fPort())
      .map(value => zio.aws.iotwireless.model.primitives.FPort(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.LoRaWANMulticastMetadata
  ): zio.aws.iotwireless.model.LoRaWANMulticastMetadata.ReadOnly = new Wrapper(
    impl
  )
}
