package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListWirelessGatewayTaskDefinitionsResponse(
    nextToken: Option[NextToken] = None,
    taskDefinitions: Option[
      Iterable[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse = {
    import ListWirelessGatewayTaskDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        taskDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.taskDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly =
    zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListWirelessGatewayTaskDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse =
      zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse(
        nextToken.map(value => value),
        taskDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def taskDefinitions: Option[
      List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly]
    ]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTaskDefinitions: ZIO[Any, AwsError, List[
      zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("taskDefinitions", taskDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ) extends zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val taskDefinitions: Option[
      List[zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.ReadOnly]
    ] = scala
      .Option(impl.taskDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotwireless.model.UpdateWirelessGatewayTaskEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse
  ): zio.aws.iotwireless.model.ListWirelessGatewayTaskDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
