package zio.aws.iotwireless.model
import java.lang.Integer
import zio.aws.iotwireless.model.primitives.{MaxResults, NextToken, FuotaTaskId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListMulticastGroupsByFuotaTaskRequest(
    id: FuotaTaskId,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest = {
    import ListMulticastGroupsByFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
      .wrap(buildAwsValue())
}
object ListMulticastGroupsByFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest =
      zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def id: FuotaTaskId
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotwireless.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.iotwireless.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest
  ): zio.aws.iotwireless.model.ListMulticastGroupsByFuotaTaskRequest.ReadOnly =
    new Wrapper(impl)
}
