package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayTaskDefinitionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayTaskDefinitionRequest(
    id: WirelessGatewayTaskDefinitionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest = {
    import GetWirelessGatewayTaskDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
      .builder()
      .id(WirelessGatewayTaskDefinitionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
      .wrap(buildAwsValue())
}
object GetWirelessGatewayTaskDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest =
      zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest(id)
    def id: WirelessGatewayTaskDefinitionId
    def getId: ZIO[Any, Nothing, WirelessGatewayTaskDefinitionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest.ReadOnly {
    override val id: WirelessGatewayTaskDefinitionId =
      zio.aws.iotwireless.model.primitives
        .WirelessGatewayTaskDefinitionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest
  ): zio.aws.iotwireless.model.GetWirelessGatewayTaskDefinitionRequest.ReadOnly =
    new Wrapper(impl)
}
