package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.WirelessGatewayId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetWirelessGatewayStatisticsRequest(
    wirelessGatewayId: WirelessGatewayId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest = {
    import GetWirelessGatewayStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest
      .builder()
      .wirelessGatewayId(
        WirelessGatewayId.unwrap(wirelessGatewayId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest.ReadOnly =
    zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest
      .wrap(buildAwsValue())
}
object GetWirelessGatewayStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest =
      zio.aws.iotwireless.model
        .GetWirelessGatewayStatisticsRequest(wirelessGatewayId)
    def wirelessGatewayId: WirelessGatewayId
    def getWirelessGatewayId: ZIO[Any, Nothing, WirelessGatewayId] =
      ZIO.succeed(wirelessGatewayId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest
  ) extends zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest.ReadOnly {
    override val wirelessGatewayId: WirelessGatewayId =
      zio.aws.iotwireless.model.primitives
        .WirelessGatewayId(impl.wirelessGatewayId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetWirelessGatewayStatisticsRequest
  ): zio.aws.iotwireless.model.GetWirelessGatewayStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
