package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.AccountLinked
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetPartnerAccountResponse(
    sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint
    ] = None,
    accountLinked: Option[AccountLinked] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse = {
    import GetPartnerAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse
      .builder()
      .optionallyWith(sidewalk.map(value => value.buildAwsValue()))(_.sidewalk)
      .optionallyWith(
        accountLinked.map(value =>
          AccountLinked.unwrap(value): java.lang.Boolean
        )
      )(_.accountLinked)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly =
    zio.aws.iotwireless.model.GetPartnerAccountResponse.wrap(buildAwsValue())
}
object GetPartnerAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetPartnerAccountResponse =
      zio.aws.iotwireless.model.GetPartnerAccountResponse(
        sidewalk.map(value => value.asEditable),
        accountLinked.map(value => value)
      )
    def sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ]
    def accountLinked: Option[AccountLinked]
    def getSidewalk: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ] = AwsError.unwrapOptionField("sidewalk", sidewalk)
    def getAccountLinked: ZIO[Any, AwsError, AccountLinked] =
      AwsError.unwrapOptionField("accountLinked", accountLinked)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse
  ) extends zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly {
    override val sidewalk: Option[
      zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.ReadOnly
    ] = scala
      .Option(impl.sidewalk())
      .map(value =>
        zio.aws.iotwireless.model.SidewalkAccountInfoWithFingerprint.wrap(value)
      )
    override val accountLinked: Option[AccountLinked] = scala
      .Option(impl.accountLinked())
      .map(value => zio.aws.iotwireless.model.primitives.AccountLinked(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetPartnerAccountResponse
  ): zio.aws.iotwireless.model.GetPartnerAccountResponse.ReadOnly = new Wrapper(
    impl
  )
}
