package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.FuotaTaskId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetFuotaTaskRequest(id: FuotaTaskId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest = {
    import GetFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.GetFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.GetFuotaTaskRequest.wrap(buildAwsValue())
}
object GetFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.GetFuotaTaskRequest =
      zio.aws.iotwireless.model.GetFuotaTaskRequest(id)
    def id: FuotaTaskId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.GetFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.GetFuotaTaskRequest
  ): zio.aws.iotwireless.model.GetFuotaTaskRequest.ReadOnly = new Wrapper(impl)
}
