package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  DeviceProfileId,
  DeviceProfileName,
  DeviceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeviceProfile(
    arn: Option[DeviceProfileArn] = None,
    name: Option[DeviceProfileName] = None,
    id: Option[DeviceProfileId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeviceProfile = {
    import DeviceProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeviceProfile
      .builder()
      .optionallyWith(
        arn.map(value => DeviceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => DeviceProfileName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => DeviceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.DeviceProfile.ReadOnly =
    zio.aws.iotwireless.model.DeviceProfile.wrap(buildAwsValue())
}
object DeviceProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeviceProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeviceProfile =
      zio.aws.iotwireless.model.DeviceProfile(
        arn.map(value => value),
        name.map(value => value),
        id.map(value => value)
      )
    def arn: Option[DeviceProfileArn]
    def name: Option[DeviceProfileName]
    def id: Option[DeviceProfileId]
    def getArn: ZIO[Any, AwsError, DeviceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, DeviceProfileName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, DeviceProfileId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceProfile
  ) extends zio.aws.iotwireless.model.DeviceProfile.ReadOnly {
    override val arn: Option[DeviceProfileArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileArn(value)
      )
    override val name: Option[DeviceProfileName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.DeviceProfileName(value)
      )
    override val id: Option[DeviceProfileId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotwireless.model.primitives.DeviceProfileId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeviceProfile
  ): zio.aws.iotwireless.model.DeviceProfile.ReadOnly = new Wrapper(impl)
}
