package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.ServiceProfileId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteServiceProfileRequest(id: ServiceProfileId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest = {
    import DeleteServiceProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest
      .builder()
      .id(ServiceProfileId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.DeleteServiceProfileRequest.ReadOnly =
    zio.aws.iotwireless.model.DeleteServiceProfileRequest.wrap(buildAwsValue())
}
object DeleteServiceProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.DeleteServiceProfileRequest =
      zio.aws.iotwireless.model.DeleteServiceProfileRequest(id)
    def id: ServiceProfileId
    def getId: ZIO[Any, Nothing, ServiceProfileId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest
  ) extends zio.aws.iotwireless.model.DeleteServiceProfileRequest.ReadOnly {
    override val id: ServiceProfileId =
      zio.aws.iotwireless.model.primitives.ServiceProfileId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.DeleteServiceProfileRequest
  ): zio.aws.iotwireless.model.DeleteServiceProfileRequest.ReadOnly =
    new Wrapper(impl)
}
