package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  ServiceProfileId,
  ServiceProfileArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateServiceProfileResponse(
    arn: Option[ServiceProfileArn] = None,
    id: Option[ServiceProfileId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse = {
    import CreateServiceProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse
      .builder()
      .optionallyWith(
        arn.map(value => ServiceProfileArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => ServiceProfileId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly =
    zio.aws.iotwireless.model.CreateServiceProfileResponse.wrap(buildAwsValue())
}
object CreateServiceProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.CreateServiceProfileResponse =
      zio.aws.iotwireless.model.CreateServiceProfileResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Option[ServiceProfileArn]
    def id: Option[ServiceProfileId]
    def getArn: ZIO[Any, AwsError, ServiceProfileArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, ServiceProfileId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse
  ) extends zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly {
    override val arn: Option[ServiceProfileArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileArn(value)
      )
    override val id: Option[ServiceProfileId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ServiceProfileId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.CreateServiceProfileResponse
  ): zio.aws.iotwireless.model.CreateServiceProfileResponse.ReadOnly =
    new Wrapper(impl)
}
