package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{WirelessDeviceId, FuotaTaskId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AssociateWirelessDeviceWithFuotaTaskRequest(
    id: FuotaTaskId,
    wirelessDeviceId: WirelessDeviceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest = {
    import AssociateWirelessDeviceWithFuotaTaskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
      .builder()
      .id(FuotaTaskId.unwrap(id): java.lang.String)
      .wirelessDeviceId(
        WirelessDeviceId.unwrap(wirelessDeviceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest.ReadOnly =
    zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
      .wrap(buildAwsValue())
}
object AssociateWirelessDeviceWithFuotaTaskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest =
      zio.aws.iotwireless.model
        .AssociateWirelessDeviceWithFuotaTaskRequest(id, wirelessDeviceId)
    def id: FuotaTaskId
    def wirelessDeviceId: WirelessDeviceId
    def getId: ZIO[Any, Nothing, FuotaTaskId] = ZIO.succeed(id)
    def getWirelessDeviceId: ZIO[Any, Nothing, WirelessDeviceId] =
      ZIO.succeed(wirelessDeviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
  ) extends zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest.ReadOnly {
    override val id: FuotaTaskId =
      zio.aws.iotwireless.model.primitives.FuotaTaskId(impl.id())
    override val wirelessDeviceId: WirelessDeviceId =
      zio.aws.iotwireless.model.primitives
        .WirelessDeviceId(impl.wirelessDeviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest
  ): zio.aws.iotwireless.model.AssociateWirelessDeviceWithFuotaTaskRequest.ReadOnly =
    new Wrapper(impl)
}
