package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.DevAddr
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AbpV1_0_x(
    devAddr: Option[DevAddr] = None,
    sessionKeys: Option[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x = {
    import AbpV1_0_x.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
      .builder()
      .optionallyWith(
        devAddr.map(value => DevAddr.unwrap(value): java.lang.String)
      )(_.devAddr)
      .optionallyWith(sessionKeys.map(value => value.buildAwsValue()))(
        _.sessionKeys
      )
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly =
    zio.aws.iotwireless.model.AbpV1_0_x.wrap(buildAwsValue())
}
object AbpV1_0_x {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.AbpV1_0_x =
      zio.aws.iotwireless.model.AbpV1_0_x(
        devAddr.map(value => value),
        sessionKeys.map(value => value.asEditable)
      )
    def devAddr: Option[DevAddr]
    def sessionKeys
        : Option[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly]
    def getDevAddr: ZIO[Any, AwsError, DevAddr] =
      AwsError.unwrapOptionField("devAddr", devAddr)
    def getSessionKeys: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly
    ] = AwsError.unwrapOptionField("sessionKeys", sessionKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ) extends zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly {
    override val devAddr: Option[DevAddr] = scala
      .Option(impl.devAddr())
      .map(value => zio.aws.iotwireless.model.primitives.DevAddr(value))
    override val sessionKeys
        : Option[zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.ReadOnly] =
      scala
        .Option(impl.sessionKeys())
        .map(value =>
          zio.aws.iotwireless.model.SessionKeysAbpV1_0_x.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.AbpV1_0_x
  ): zio.aws.iotwireless.model.AbpV1_0_x.ReadOnly = new Wrapper(impl)
}
