package zio.aws.iotwireless.model
import zio.aws.iotwireless.model.primitives.{
  WirelessGatewayId,
  WirelessGatewayArn,
  ISODateTimeString,
  WirelessGatewayName,
  Description
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class WirelessGatewayStatistics(
    arn: Option[WirelessGatewayArn] = None,
    id: Option[WirelessGatewayId] = None,
    name: Option[WirelessGatewayName] = None,
    description: Option[Description] = None,
    loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANGateway] = None,
    lastUplinkReceivedAt: Option[ISODateTimeString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics = {
    import WirelessGatewayStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
      .builder()
      .optionallyWith(
        arn.map(value => WirelessGatewayArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        id.map(value => WirelessGatewayId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => WirelessGatewayName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(loRaWAN.map(value => value.buildAwsValue()))(_.loRaWAN)
      .optionallyWith(
        lastUplinkReceivedAt.map(value =>
          ISODateTimeString.unwrap(value): java.lang.String
        )
      )(_.lastUplinkReceivedAt)
      .build()
  }
  def asReadOnly: zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly =
    zio.aws.iotwireless.model.WirelessGatewayStatistics.wrap(buildAwsValue())
}
object WirelessGatewayStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotwireless.model.WirelessGatewayStatistics =
      zio.aws.iotwireless.model.WirelessGatewayStatistics(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        loRaWAN.map(value => value.asEditable),
        lastUplinkReceivedAt.map(value => value)
      )
    def arn: Option[WirelessGatewayArn]
    def id: Option[WirelessGatewayId]
    def name: Option[WirelessGatewayName]
    def description: Option[Description]
    def loRaWAN: Option[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly]
    def lastUplinkReceivedAt: Option[ISODateTimeString]
    def getArn: ZIO[Any, AwsError, WirelessGatewayArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, WirelessGatewayId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, WirelessGatewayName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLoRaWAN: ZIO[
      Any,
      AwsError,
      zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly
    ] = AwsError.unwrapOptionField("loRaWAN", loRaWAN)
    def getLastUplinkReceivedAt: ZIO[Any, AwsError, ISODateTimeString] =
      AwsError.unwrapOptionField("lastUplinkReceivedAt", lastUplinkReceivedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ) extends zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly {
    override val arn: Option[WirelessGatewayArn] = scala
      .Option(impl.arn())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayArn(value)
      )
    override val id: Option[WirelessGatewayId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayId(value)
      )
    override val name: Option[WirelessGatewayName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.iotwireless.model.primitives.WirelessGatewayName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.iotwireless.model.primitives.Description(value))
    override val loRaWAN
        : Option[zio.aws.iotwireless.model.LoRaWANGateway.ReadOnly] = scala
      .Option(impl.loRaWAN())
      .map(value => zio.aws.iotwireless.model.LoRaWANGateway.wrap(value))
    override val lastUplinkReceivedAt: Option[ISODateTimeString] = scala
      .Option(impl.lastUplinkReceivedAt())
      .map(value =>
        zio.aws.iotwireless.model.primitives.ISODateTimeString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayStatistics
  ): zio.aws.iotwireless.model.WirelessGatewayStatistics.ReadOnly = new Wrapper(
    impl
  )
}
