package zio.aws.iotwireless.model
import scala.jdk.CollectionConverters._
sealed trait WirelessGatewayEvent {
  def unwrap
      : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent
}
object WirelessGatewayEvent {
  def wrap(
      value: software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent
  ): zio.aws.iotwireless.model.WirelessGatewayEvent = value match {
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.CUPS_REQUEST =>
      val r = CUPS_Request
      r
    case software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.CERTIFICATE =>
      val r = Certificate
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotwireless.model.WirelessGatewayEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.UNKNOWN_TO_SDK_VERSION
  }
  case object CUPS_Request
      extends zio.aws.iotwireless.model.WirelessGatewayEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.CUPS_REQUEST
  }
  case object Certificate
      extends zio.aws.iotwireless.model.WirelessGatewayEvent {
    override def unwrap
        : software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent =
      software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEvent.CERTIFICATE
  }
}
